# Algorithm Language Codes dgMP ValueSet - Medication IG DE v1.0.3

* [**Table of Contents**](toc.md)
* [**FHIR Summary**](artifacts.md)
* **Algorithm Language Codes dgMP ValueSet**

## ValueSet: Algorithm Language Codes dgMP ValueSet 

| | |
| :--- | :--- |
| *Official URL*:http://ig.fhir.de/igs/medication/ValueSet/AlgorithmLanguageCodesDgMP | *Version*:1.0.3 |
| Active as of 2025-11-19 | *Computable Name*:AlgorithmLanguageCodesDgMPVS |

 
Dieses ValueSet enthält die im dgMP unterstützten Sprachen für Algorithmen, die in der Dosierung verwendet werden können. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

This value set contains 1 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "AlgorithmLanguageCodesDgMP",
  "url" : "http://ig.fhir.de/igs/medication/ValueSet/AlgorithmLanguageCodesDgMP",
  "version" : "1.0.3",
  "name" : "AlgorithmLanguageCodesDgMPVS",
  "title" : "Algorithm Language Codes dgMP ValueSet",
  "status" : "active",
  "date" : "2025-11-19T17:22:58+01:00",
  "publisher" : "HL7 Deutschland e.V.",
  "contact" : [
    {
      "name" : "HL7 Deutschland e.V.",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.de"
        }
      ]
    }
  ],
  "description" : "Dieses ValueSet enthält die im dgMP unterstützten Sprachen für Algorithmen, die in der Dosierung verwendet werden können.",
  "compose" : {
    "include" : [
      {
        "system" : "urn:ietf:bcp:47",
        "concept" : [
          {
            "code" : "de-DE"
          }
        ]
      }
    ]
  }
}

```
