# Medication Statement dgMP - Medication IG DE v1.0.3

* [**Table of Contents**](toc.md)
* [**FHIR Summary**](artifacts.md)
* **Medication Statement dgMP**

## Resource Profile: Medication Statement dgMP ( Abstract ) 

| | |
| :--- | :--- |
| *Official URL*:http://ig.fhir.de/igs/medication/StructureDefinition/MedicationStatementDgMP | *Version*:1.0.3 |
| Active as of 2025-11-19 | *Computable Name*:MedicationStatementDgMP |

 
Dieses Profil dient ausschließlich der Validierung des Implementation Guides und ist nicht für den produktiven Einsatz gedacht. Stattdessen sollte das jeweils passende Dosage-Profil direkt in das eigene Profil eingebunden werden. 

## Verwendung

Dieses Profil dient ausschließlich der Validierung des Implementation Guides und ist nicht für den produktiven Einsatz gedacht

**Usages:**

* Examples for this Profile: [MedicationStatement/MS-Dosage-1010](MedicationStatement-MS-Dosage-1010.md), [MedicationStatement/MS-Dosage-DayOfWeek](MedicationStatement-MS-Dosage-DayOfWeek.md), [MedicationStatement/MS-Dosage-Freetext](MedicationStatement-MS-Dosage-Freetext.md), [MedicationStatement/MS-Dosage-Interval](MedicationStatement-MS-Dosage-Interval.md) and [MedicationStatement/MS-Dosage-TimeOfDay](MedicationStatement-MS-Dosage-TimeOfDay.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.fhir.medication|current/StructureDefinition/MedicationStatementDgMP)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-MedicationStatementDgMP.csv), [Excel](StructureDefinition-MedicationStatementDgMP.xlsx), [Schematron](StructureDefinition-MedicationStatementDgMP.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "MedicationStatementDgMP",
  "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationStatementDgMP",
  "version" : "1.0.3",
  "name" : "MedicationStatementDgMP",
  "title" : "Medication Statement dgMP",
  "status" : "active",
  "date" : "2025-11-19T17:22:58+01:00",
  "publisher" : "HL7 Deutschland e.V.",
  "contact" : [
    {
      "name" : "HL7 Deutschland e.V.",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.de"
        }
      ]
    }
  ],
  "description" : "Dieses Profil dient ausschließlich der Validierung des Implementation Guides und ist nicht für den produktiven Einsatz gedacht. Stattdessen sollte das jeweils passende Dosage-Profil direkt in das eigene Profil eingebunden werden.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : true,
  "type" : "MedicationStatement",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MedicationStatement",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationStatement",
        "path" : "MedicationStatement"
      },
      {
        "id" : "MedicationStatement.extension:renderedDosageInstruction",
        "path" : "MedicationStatement.extension",
        "sliceName" : "renderedDosageInstruction",
        "short" : "Dosierungsanweisung",
        "definition" : "Diese R5 backport Extension enthält die algorithmisch generierten gerenderten Dosierungsanweisungen, die für den Patienten bestimmt sind, um eine klare und verständliche Anweisung zur Einnahme des Medikaments zu geben.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationStatement.renderedDosageInstruction"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.extension:renderedDosageInstruction.value[x]",
        "path" : "MedicationStatement.extension.value[x]",
        "short" : "Hinweis: In der ersten Ausbaustufe des dgMP ist nur einfacher Text (String) zulässig; Markdown wird nicht unterstützt.",
        "definition" : "Abweichend von FHIR R5 (Typ Markdown) darf in der ersten Ausbaustufe des dgMP ausschließlich Klartext ohne Markdown‑Formatierungen (z. B. Überschriften, Listen, Links) geliefert werden."
      },
      {
        "id" : "MedicationStatement.extension:generatedDosageInstructionsMeta",
        "path" : "MedicationStatement.extension",
        "sliceName" : "generatedDosageInstructionsMeta",
        "short" : "Metadaten zu den generierten Dosierungsanweisungen",
        "definition" : "Diese Extension enthält zusätzliche Metadaten zu den automatisch generierten Dosierungsanweisungen, wie z.B. Informationen zur Generierung oder zum Ursprung der Daten.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.dosage",
        "path" : "MedicationStatement.dosage",
        "short" : "Angabe der Dosierinformationen strukturiert oder als Freitext",
        "type" : [
          {
            "code" : "Dosage",
            "profile" : [
              "http://ig.fhir.de/igs/medication/StructureDefinition/DosageDgMP"
            ]
          }
        ]
      }
    ]
  }
}

```
