# MS-Dosage-Interval - Medication IG DE v1.0.3

* [**Table of Contents**](toc.md)
* [**FHIR Summary**](artifacts.md)
* **MS-Dosage-Interval**

## Example MedicationStatement: MS-Dosage-Interval

Profile: [Medication Statement dgMP](StructureDefinition-MedicationStatementDgMP.md)

**Extension Definition for MedicationStatement.renderedDosageInstruction for Version 5.0**: 

alle 3 Tage: je 1 Stück

> **Generated Dosage Instructions Meta**
* algorithmVersion: 1.0.1
* language: de-DE

**status**: Active

**medication**: Test Medication

**subject**: Patient

> **dosage****timing**: Once per 3 days

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 1 Stück(Details: UCUM code1 = '1') |




## Resource Content

```json
{
  "resourceType" : "MedicationStatement",
  "id" : "MS-Dosage-Interval",
  "meta" : {
    "profile" : [
      "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationStatementDgMP"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationStatement.renderedDosageInstruction",
      "valueMarkdown" : "alle 3 Tage: je 1 Stück"
    },
    {
      "extension" : [
        {
          "url" : "algorithmVersion",
          "valueString" : "1.0.1"
        },
        {
          "url" : "language",
          "valueCode" : "de-DE"
        }
      ],
      "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
    }
  ],
  "status" : "active",
  "medicationCodeableConcept" : {
    "text" : "Test Medication"
  },
  "subject" : {
    "display" : "Patient"
  },
  "dosage" : [
    {
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 3,
          "periodUnit" : "d"
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 1,
            "unit" : "Stück",
            "system" : "http://unitsofmeasure.org",
            "code" : "1"
          }
        }
      ]
    }
  ]
}

```
