# Example-MR-Bug-MultipleWhen-DayOfWeek - Medication IG DE v1.0.3

* [**Table of Contents**](toc.md)
* [**FHIR Summary**](artifacts.md)
* **Example-MR-Bug-MultipleWhen-DayOfWeek**

## Example MedicationRequest: Example-MR-Bug-MultipleWhen-DayOfWeek

Profile: [Medication Request dgMP](StructureDefinition-MedicationRequestDgMP.md)

**Extension Definition for MedicationRequest.renderedDosageInstruction for Version 5.0**: 

dienstags 1-0-1-0 Stück; donnerstags 1-0-1-0 Stück

> **Generated Dosage Instructions Meta**
* algorithmVersion: 1.0.1
* language: de-DE

**status**: Active

**intent**: Order

**medication**: Test Medication

**subject**: Patient

> **dosageInstruction****timing**: Morning, Evening, 4 per 1 week

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 1 Stück(Details: KBV_CS_SFHIR_BMP_DOSIEREINHEIT code1 = '1') |




## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "Example-MR-Bug-MultipleWhen-DayOfWeek",
  "meta" : {
    "profile" : [
      "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.renderedDosageInstruction",
      "valueMarkdown" : "dienstags 1-0-1-0 Stück; donnerstags 1-0-1-0 Stück"
    },
    {
      "extension" : [
        {
          "url" : "algorithmVersion",
          "valueString" : "1.0.1"
        },
        {
          "url" : "language",
          "valueCode" : "de-DE"
        }
      ],
      "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
    }
  ],
  "status" : "active",
  "intent" : "order",
  "medicationCodeableConcept" : {
    "text" : "Test Medication"
  },
  "subject" : {
    "display" : "Patient"
  },
  "dosageInstruction" : [
    {
      "timing" : {
        "repeat" : {
          "frequency" : 4,
          "period" : 1,
          "periodUnit" : "wk",
          "dayOfWeek" : ["tue", "thu"],
          "when" : ["MORN", "EVE"]
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 1,
            "unit" : "Stück",
            "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
            "code" : "1"
          }
        }
      ]
    }
  ]
}

```
