# FHIR Implementation Guide für medikationsbezogene Anwendungsfälle im deutschen Gesundheitswesen - Medication IG DE v1.0.2

* [**Table of Contents**](toc.md)
* **FHIR Implementation Guide für medikationsbezogene Anwendungsfälle im deutschen Gesundheitswesen**

## FHIR Implementation Guide für medikationsbezogene Anwendungsfälle im deutschen Gesundheitswesen

| | |
| :--- | :--- |
| *Official URL*:http://ig.fhir.de/igs/medication/ImplementationGuide/de.fhir.medication | *Version*:1.0.2 |
| Active as of 2025-10-29 | *Computable Name*:MedicationDE |

### Kurzbeschreibung

Dieser Implementation Guide (IG) beschreibt die standardisierte und interoperable Abbildung medikationsbezogener Informationen und Prozesse im deutschen Gesundheitswesen auf Basis von HL7® FHIR®. Ziel ist es, sektorenübergreifende Anwendungsfälle - wie beispielsweise die strukturierte Dosierungsinformation im E-Rezept, den elektronischen Medikationsplan oder den Austausch mittels [ISiK](https://fachportal.gematik.de/informationen-fuer/isik/bestaetigungsverfahren-isik) - zu ermöglichen und zu harmonisieren.

Der IG enthält die Beschreibung der jeweiligen Anwendungsfälle sowie begleitende Dokumentation.

### Aktuelle Anwendungsfälle

Dieser Implementation Guide wird kontinuierlich weiterentwickelt und verbessert. Aktuell werden folgende Anwendungsfälle unterstützt:

* Strukturierte und textuelle Darstellung von [Dosierungen](./dosierung-einfuehrung.md)

### Must Support

Elemente mit der Eigenschaft [mustSupport](https://www.hl7.org/fhir/profiling.html#mustsupport) müssen immer implementiert werden. Hierbei handelt es sich um Elemente, die unabhängig von der Kardinalität (Ausnahme: 0…0) unterstützt werden müssen, sofern die entsprechenden Informationen vorliegen.

Die Software, welche die Dateien erstellt, muss die mit „mustSupport“ gekennzeichneten Elemente (mustSupport value="true") unterstützen - befüllen und übermitteln können.

Die Software, welche die Dateien verarbeitet, muss die mit „mustSupport“ gekennzeichneten Elemente (mustSupport value="true") unterstützen - auslesen und verarbeiten können.

### Zielgruppen

* Softwarehersteller und Systemintegratoren im Gesundheitswesen
* Entwickler:innen von FHIR-basierten Systemen
* Ärzt:innen, Apotheker:innen, Pflegekräfte
* Fachexpert:innen für Interoperabilität und Arzneimitteltherapie

### Mitwirkende Organisationen

Durch Input und Feedback haben folgende Organisationen an der Erstellung dieses Implementation Guides mitgewirkt:

* Bundesvereinigung Deutscher Apothekerverbände
* Deutscher Apothekerverband
* Deutsche Krankenhausgesellschaft
* gematik GmbH
* GKV-Spitzenverband
* HL7 Deutschland
* Kassenärztliche Bundesvereinigung
* Kompetenzzentrum für Interoperabilität im Gesundheitswesen (KIG)
* Verband der Privaten Krankenversicherung

### Abhängigkeiten

Dieser IG verwendet zur Kodierung der doseQuantity [KBV_VS_SFHIR_BMP_DOSIEREINHEIT](https://fhir.kbv.de/ValueSet/KBV_VS_SFHIR_BMP_DOSIEREINHEIT) & [KBV_CS_SFHIR_BMP_DOSIEREINHEIT](https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT) welche bewusst nicht als Abhängigkeit deklariert worden sind.



### Kontakt und Feedback

Für Fragen und Feedback wenden Sie sich bitte an [info@hl7.de](mailto:info@hl7.de) oder nutzen Sie das [GitHub-Repository](https://github.com/hl7germany/medication-ig-de-r4/issues).

### Rechtliche Hinweise

Dieser Implementation Guide wurde in Zusammenarbeit zwischen

* [HL7 Deutschland e.V.](https://hl7.de/)
* [gematik GmbH](https://www.gematik.de/)

erarbeitet.

Copyright © 2025 HL7 Deutschland e.V.

HL7®, HEALTH LEVEL SEVEN®, FHIR® und das FHIR®-Logo sind Marken von Health Level Seven International, eingetragen beim United States Patent and Trademark Office.

