# Medication Dispense dgMP - Medication IG DE v1.0.2

* [**Table of Contents**](toc.md)
* [**FHIR Summary**](artifacts.md)
* **Medication Dispense dgMP**

## Resource Profile: Medication Dispense dgMP ( Abstract ) 

| | |
| :--- | :--- |
| *Official URL*:http://ig.fhir.de/igs/medication/StructureDefinition/MedicationDispenseDgMP | *Version*:1.0.2 |
| Active as of 2025-10-29 | *Computable Name*:MedicationDispenseDgMP |

 
Dieses Profil dient ausschließlich der Validierung des Implementation Guides und ist nicht für den produktiven Einsatz gedacht. Stattdessen sollte das jeweils passende Dosage-Profil direkt in das eigene Profil eingebunden werden. 

## Verwendung

Dieses Profil dient ausschließlich der Validierung des Implementation Guides und ist nicht für den produktiven Einsatz gedacht

**Usages:**

* Examples for this Profile: [MedicationDispense/MD-Dosage-1020](MedicationDispense-MD-Dosage-1020.md), [MedicationDispense/MD-Dosage-Bounds-Decimals](MedicationDispense-MD-Dosage-Bounds-Decimals.md), [MedicationDispense/MD-Dosage-DayOfWeek-Time](MedicationDispense-MD-Dosage-DayOfWeek-Time.md), [MedicationDispense/MD-Dosage-Freetext](MedicationDispense-MD-Dosage-Freetext.md) and [MedicationDispense/MD-Dosage-Interval-Time](MedicationDispense-MD-Dosage-Interval-Time.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.fhir.medication|current/StructureDefinition/MedicationDispenseDgMP)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-MedicationDispenseDgMP.csv), [Excel](StructureDefinition-MedicationDispenseDgMP.xlsx), [Schematron](StructureDefinition-MedicationDispenseDgMP.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "MedicationDispenseDgMP",
  "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationDispenseDgMP",
  "version" : "1.0.2",
  "name" : "MedicationDispenseDgMP",
  "title" : "Medication Dispense dgMP",
  "status" : "active",
  "date" : "2025-10-29T11:26:30+01:00",
  "publisher" : "HL7 Deutschland e.V.",
  "contact" : [
    {
      "name" : "HL7 Deutschland e.V.",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.de"
        }
      ]
    }
  ],
  "description" : "Dieses Profil dient ausschließlich der Validierung des Implementation Guides und ist nicht für den produktiven Einsatz gedacht. Stattdessen sollte das jeweils passende Dosage-Profil direkt in das eigene Profil eingebunden werden.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rx-dispense-rmim",
      "uri" : "http://www.hl7.org/v3/PORX_RM020070UV",
      "name" : "V3 Pharmacy Dispense RMIM"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : true,
  "type" : "MedicationDispense",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MedicationDispense",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationDispense",
        "path" : "MedicationDispense"
      },
      {
        "id" : "MedicationDispense.extension:renderedDosageInstruction",
        "path" : "MedicationDispense.extension",
        "sliceName" : "renderedDosageInstruction",
        "short" : "Dosierungsanweisung",
        "definition" : "Diese R5 backport Extension enthält die algorithmisch generierten gerenderten Dosierungsanweisungen, die für den Patienten bestimmt sind, um eine klare und verständliche Anweisung zur Einnahme des Medikaments zu geben.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationDispense.renderedDosageInstruction"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.extension:renderedDosageInstruction.value[x]",
        "path" : "MedicationDispense.extension.value[x]",
        "short" : "Hinweis: In der ersten Ausbaustufe des dgMP ist nur einfacher Text (String) zulässig; Markdown wird nicht unterstützt.",
        "definition" : "Abweichend von FHIR R5 (Typ Markdown) darf in der ersten Ausbaustufe des dgMP ausschließlich Klartext ohne Markdown‑Formatierungen (z. B. Überschriften, Listen, Links) geliefert werden."
      },
      {
        "id" : "MedicationDispense.extension:generatedDosageInstructionsMeta",
        "path" : "MedicationDispense.extension",
        "sliceName" : "generatedDosageInstructionsMeta",
        "short" : "Metadaten zu den generierten Dosierungsanweisungen",
        "definition" : "Diese Extension enthält zusätzliche Metadaten zu den automatisch generierten Dosierungsanweisungen, wie z.B. Informationen zur Generierung oder zum Ursprung der Daten.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.dosageInstruction",
        "path" : "MedicationDispense.dosageInstruction",
        "short" : "Angabe der Dosierinformationen strukturiert oder als Freitext",
        "type" : [
          {
            "code" : "Dosage",
            "profile" : [
              "http://ig.fhir.de/igs/medication/StructureDefinition/DosageDgMP"
            ]
          }
        ]
      }
    ]
  }
}

```
