# Dosage DE - Medication IG DE v1.0.2

* [**Table of Contents**](toc.md)
* [**FHIR Summary**](artifacts.md)
* **Dosage DE**

## Data Type Profile: Dosage DE 

| | |
| :--- | :--- |
| *Official URL*:http://ig.fhir.de/igs/medication/StructureDefinition/DosageDE | *Version*:1.0.2 |
| Active as of 2025-10-29 | *Computable Name*:DosageDE |

 
Gibt an, wie das Medikament eingenommen oder verabreicht wurde bzw. eingenommen oder verabreicht werden soll - entweder selbst vom Patienten eingenommen oder bei Fremdverabreichung von Dritten (z. B. Leistungserbringer, Angehörige) verabreicht. 

## Verwendung

Dieses Profil beschreibt die Verwendung der FHIR-Ressource `Dosage` im deutschen Kontext und ist für die allgemeine Interoperabilität konzipiert. Das Profil ist offen gehalten und setzt keine spezifischen Dosierschemata voraus, sondern legt ein „Must Support“ auf alle relevanten Felder. Ziel ist es, eine flexible und breit einsetzbare Abbildung von Dosierungsangaben zu ermöglichen, wie sie in unterschiedlichen Primärsystemen und Anwendungsfällen benötigt wird.

**Empfehlung:**
 Nutzen Sie dieses Profil für alle Anwendungsfälle, in denen Dosierungsinformationen interoperabel ausgetauscht werden sollen. Orientieren Sie sich bei der Umsetzung an den empfohlenen Dosierschemata, um eine konsistente und verständliche Darstellung zu gewährleisten.

Weitere Hinweise und Beispiele zu bewährten Dosierschemata ist unter [Unterstützte Dosierungen](./dosierung-einfuehrung.md#unterst%C3%BCtzte-dosierungen) beschrieben.

**Usages:**

* Derived from this DataType Profile: [Dosage dgMP](StructureDefinition-DosageDgMP.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.fhir.medication|current/StructureDefinition/DosageDE)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-DosageDE.csv), [Excel](StructureDefinition-DosageDE.xlsx), [Schematron](StructureDefinition-DosageDE.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "DosageDE",
  "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/DosageDE",
  "version" : "1.0.2",
  "name" : "DosageDE",
  "title" : "Dosage DE",
  "status" : "active",
  "date" : "2025-10-29T11:26:30+01:00",
  "publisher" : "HL7 Deutschland e.V.",
  "contact" : [
    {
      "name" : "HL7 Deutschland e.V.",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.de"
        }
      ]
    }
  ],
  "description" : "Gibt an, wie das Medikament eingenommen oder verabreicht wurde bzw. eingenommen oder verabreicht werden soll - entweder selbst vom Patienten eingenommen oder bei Fremdverabreichung von Dritten (z. B. Leistungserbringer, Angehörige) verabreicht.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "Dosage",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Dosage",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Dosage",
        "path" : "Dosage",
        "constraint" : [
          {
            "key" : "DosageStructuredOrFreeTextWarning",
            "severity" : "warning",
            "human" : "Die Dosierungsangabe darf entweder nur als Freitext oder nur als vollständige strukturierte Information erfolgen — eine Mischung ist nicht erlaubt.",
            "expression" : "(%resource.ofType(MedicationRequest).dosageInstruction | \n ofType(MedicationDispense).dosageInstruction | \n ofType(MedicationStatement).dosage).all(\n  (text.exists() and timing.empty() and doseAndRate.empty()) or\n  (text.empty() and (timing.exists() or doseAndRate.exists()))\n)\n",
            "source" : "http://ig.fhir.de/igs/medication/StructureDefinition/DosageDE"
          },
          {
            "key" : "DosageStructuredRequiresBoth",
            "severity" : "error",
            "human" : "Wenn eine strukturierte Dosierungsangabe erfolgt, müssen sowohl timing als auch doseAndRate angegeben werden.",
            "expression" : "(%resource.ofType(MedicationRequest).dosageInstruction | \n ofType(MedicationDispense).dosageInstruction | \n ofType(MedicationStatement).dosage).all(\n  (timing.exists() implies doseAndRate.exists()) and\n  (doseAndRate.exists() implies timing.exists())\n)\n",
            "source" : "http://ig.fhir.de/igs/medication/StructureDefinition/DosageDE"
          },
          {
            "key" : "DosageDoseUnitSameCode",
            "severity" : "error",
            "human" : "Die Dosiereinheit muss über alle Dosierungen gleich sein.",
            "expression" : "(%resource.ofType(MedicationRequest).dosageInstruction | ofType(MedicationDispense).dosageInstruction | ofType(MedicationStatement).dosage).all(\ndoseAndRate.exists() implies\n  %resource.dosageInstruction.doseAndRate.dose.ofType(Quantity).code.distinct().count() = 1\n)",
            "source" : "http://ig.fhir.de/igs/medication/StructureDefinition/DosageDE"
          },
          {
            "key" : "DosageWarnungViererschemaInText",
            "severity" : "warning",
            "human" : "Hinweis: In Dosage.text wurde ein Viererschema (z. B. 1-1-1-1) erkannt. Bitte prüfen, ob dies strukturiert abgebildet werden kann.",
            "expression" : "text.exists() implies text.matches('.*\\\\d+\\\\s*[-–]\\\\s*\\\\d+\\\\s*[-–]\\\\s*\\\\d+\\\\s*[-–]\\\\d+.*').not()",
            "source" : "http://ig.fhir.de/igs/medication/StructureDefinition/DosageDE"
          },
          {
            "key" : "FreeTextSingleDosageOnlyWarning",
            "severity" : "warning",
            "human" : "Wenn eine Dosierung als reiner Freitext angegeben ist, soll nur genau ein Dosage-Element existieren.",
            "expression" : "(\n  (%resource.ofType(MedicationRequest).dosageInstruction |\n   %resource.ofType(MedicationDispense).dosageInstruction |\n   %resource.ofType(MedicationStatement).dosage\n  ).exists(text.exists() and timing.empty() and doseAndRate.empty())\n)\nimplies\n(\n  (%resource.ofType(MedicationRequest).dosageInstruction |\n   %resource.ofType(MedicationDispense).dosageInstruction |\n   %resource.ofType(MedicationStatement).dosage\n  ).count() = 1\n)",
            "source" : "http://ig.fhir.de/igs/medication/StructureDefinition/DosageDE"
          }
        ]
      },
      {
        "id" : "Dosage.text",
        "path" : "Dosage.text",
        "short" : "Freitext-Dosierungsanweisungen, z. B. 'Maximal 3x täglich 1 Stück bei Bedarf'",
        "definition" : "Freitext-Dosierungsanweisungen, z. B. 'Maximal 3x täglich 1 Stück bei Bedarf'. Als Quelle dient hier ausschließlich der Arzt oder Apotheker",
        "comment" : "Die Freitextdosierung sollte nur angegeben werden, wenn aufgrund der Komplexität keine strukturierte Dosierung möglich ist, um widersprüchliche Anweisungen zu vermeiden.",
        "mustSupport" : true
      },
      {
        "id" : "Dosage.timing",
        "path" : "Dosage.timing",
        "short" : "Wann das Medikament verabreicht werden soll",
        "definition" : "Wann das Medikament verabreicht werden soll.",
        "comment" : "Um widersprüchliche Anweisungen zu vermeiden, ist entweder Dosage.timing oder Dosage.text zu befüllen. Falls eine strukturierte Dosierung als Text abgebildet werden soll ist dafür die GeneratedDosageInstructionsMeta Extension zu verwenden.",
        "type" : [
          {
            "code" : "Timing",
            "profile" : [
              "http://ig.fhir.de/igs/medication/StructureDefinition/TimingDE"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Dosage.doseAndRate",
        "path" : "Dosage.doseAndRate",
        "short" : "Menge des verabreichten Medikaments",
        "definition" : "Die verabreichte Menge des Medikaments.",
        "mustSupport" : true
      },
      {
        "id" : "Dosage.doseAndRate.dose[x]",
        "path" : "Dosage.doseAndRate.dose[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Dosage.doseAndRate.dose[x]:doseQuantity",
        "path" : "Dosage.doseAndRate.dose[x]",
        "sliceName" : "doseQuantity",
        "short" : "Menge des Medikaments pro Dosis",
        "definition" : "Menge des Medikaments pro Dosis.",
        "comment" : "Beachten Sie, dass dies die Menge des angegebenen Medikaments angibt, nicht die Menge für die einzelnen Wirkstoffe. Jede Wirkstoffmenge kann in der Medication-Ressource kommuniziert werden. Zum Beispiel, wenn man angeben möchte, dass eine Tablette 375 mg enthält und die Dosis eine Tablette beträgt, kann man die Medication-Ressource verwenden, um zu dokumentieren, dass die Tablette aus 375 mg des Wirkstoffs XYZ besteht. Alternativ, wenn die Dosis 375 mg beträgt, muss man möglicherweise nur angeben, dass es sich um eine Tablette handelt. Bei einer Infusion wie Dopamin, bei der 400 mg Dopamin in 500 ml einer Infusionslösung gemischt werden, würde dies alles in der Medication-Ressource kommuniziert werden. Wenn die Verabreichung nicht als sofortig vorgesehen ist (Rate ist vorhanden oder Timing hat eine Dauer), kann dies angegeben werden, um die Gesamtmenge anzugeben, die über den im Zeitplan angegebenen Zeitraum verabreicht werden soll, z. B. 500 ml in der Dosis, wobei Timing verwendet wird, um anzugeben, dass dies über 4 Stunden erfolgen soll.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/SimpleQuantity"]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://ig.fhir.de/igs/medication/ValueSet/DosageDoseQuantityDE"
        }
      }
    ]
  }
}

```
