# MD-Dosage-Interval-Time - Medication IG DE v1.0.2

* [**Table of Contents**](toc.md)
* [**FHIR Summary**](artifacts.md)
* **MD-Dosage-Interval-Time**

## Example MedicationDispense: MD-Dosage-Interval-Time

Profile: [Medication Dispense dgMP](StructureDefinition-MedicationDispenseDgMP.md)

**Extension Definition for MedicationDispense.renderedDosageInstruction for Version 5.0**: 

alle 2 Tage: 09:00 Uhr — je 1 Stück; 21:00 Uhr — je 2 Stück

> **Generated Dosage Instructions Meta**
* algorithmVersion: 1.0.1
* language: de-DE

**status**: Completed

**medication**: Test Medication

**subject**: Patient

> **dosageInstruction****timing**: Once per 2 days

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 1 Stück(Details: UCUM code1 = '1') |


> **dosageInstruction****timing**: Once per 2 days

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 2 Stück(Details: UCUM code1 = '1') |




## Resource Content

```json
{
  "resourceType" : "MedicationDispense",
  "id" : "MD-Dosage-Interval-Time",
  "meta" : {
    "profile" : [
      "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationDispenseDgMP"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationDispense.renderedDosageInstruction",
      "valueMarkdown" : "alle 2 Tage: 09:00 Uhr — je 1 Stück; 21:00 Uhr — je 2 Stück"
    },
    {
      "extension" : [
        {
          "url" : "algorithmVersion",
          "valueString" : "1.0.1"
        },
        {
          "url" : "language",
          "valueCode" : "de-DE"
        }
      ],
      "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
    }
  ],
  "status" : "completed",
  "medicationCodeableConcept" : {
    "text" : "Test Medication"
  },
  "subject" : {
    "display" : "Patient"
  },
  "dosageInstruction" : [
    {
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 2,
          "periodUnit" : "d",
          "timeOfDay" : ["09:00:00"]
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 1,
            "unit" : "Stück",
            "system" : "http://unitsofmeasure.org",
            "code" : "1"
          }
        }
      ]
    },
    {
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 2,
          "periodUnit" : "d",
          "timeOfDay" : ["21:00:00"]
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 2,
            "unit" : "Stück",
            "system" : "http://unitsofmeasure.org",
            "code" : "1"
          }
        }
      ]
    }
  ]
}

```
