# Schema für Kombinationen von Wochentagen - Medication IG DE v1.0.1

* [**Table of Contents**](toc.md)
* **Schema für Kombinationen von Wochentagen**

## Schema für Kombinationen von Wochentagen

Dieses Schema gibt an, an welchen Wochentagen einer Kalenderwoche das Medikament angewandt werden soll und trifft zudem eine Aussage, zu welchen Uhrzeiten oder Tageszeiten die Anwendung an den betreffenden Kalendertagen erfolgen soll.

In diesem Anwendungsfall wird davon ausgegangen, dass das Arzneimittel wöchentlich (für die geplante Dauer) in einem gleichbleibenden Wochentagsschema angewandt wird. Es wird zudem ermöglicht:

* ein Uhrzeiten-Schema oder Tageszeitenschema für einzelne Wochentage festzulegen
* eine abweichende Dosis abhängig von der Uhrzeit/Tageszeit/Wochentag anzugeben und
* die geplante Dauer der Anwendung zu begrenzen.

### Beipiel

Folgende weitere Beispiele sind in diesem IG dargestellt:

| | | |
| :--- | :--- | :--- |
| Montags und Freitags 1-0-1-0 | [Example-MR-Dosage-comb-dayofweek-1](./MedicationRequest-Example-MR-Dosage-comb-dayofweek-1.md) |   |
| Montags und Freitags 1-0-2-0 | [Example-MR-Dosage-comb-dayofweek-2](./MedicationRequest-Example-MR-Dosage-comb-dayofweek-2.md) |   |
| Unsortierte Wochentage | [Example-MR-Dosage-comb-dayofweek-unsorted](./MedicationRequest-Example-MR-Dosage-comb-dayofweek-unsorted.md) |   |
| Montags und Freitags 1 Stück um 08:00 Uhr und 2 Stück um 10:00 Uhr - für 3 Wochen | [Example-MR-Dosage-comb-dayofweek-3](./MedicationRequest-Example-MR-Dosage-comb-dayofweek-3.md) |   |

### Angabe und Erkennung der Dosierart

Diese Dosierungsart wird daran erkannt, dass folgende Felder unter `Dosage.timing.repeat` angegeben sind:

* `dayOfWeek`
* `frequency`
* `period`
* `periodUnit` in Wochen (wk)
* und `when` ODER `timeOfDay` existieren
* opt. Angabe von `bounds[x]`

Folgende FHIR-Path Expression auf Ebene von `Dosage.timing.repeat` liefert die Angabe, ob es sich um das Schema handelt:

```
timing.repeat.dayOfWeek.exists() and
timing.repeat.frequency.exists() and
timing.repeat.period.exists() and
timing.repeat.periodUnit = 'wk' and
  (
    (timing.repeat.timeOfDay.exists() and timing.repeat.when.empty()) or
    (timing.repeat.when.exists() and timing.repeat.timeOfDay.empty())
  )

```

Der Wert von frequency entspricht dabei dem Produkt aus der Anzahl von Elementen in `when`, bzw. `timeOfDay` und `dayOfWeek`.

und entweder `when` oder `timeOfDay`. Damit kann diese Dosierangabe verwendet werden um eine Interval angabe auf Tageszeit oder Uhrzeit zu kombinieren.

Lesende Systeme werten entsprechend auch `Dosage.timing.repeat` aus. Wenn die oben genannten Felder angegeben sind, ist dem Nutzer anzuzeigen, dass die Dosierung nach einem Interval mit Tageszeit oder Uhrzeitbezug definiert ist.

