# FHIR Summary - Medication IG DE v1.0.1

* [**Table of Contents**](toc.md)
* **FHIR Summary**

## FHIR Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Structures: Abstract Profiles 

These are profiles on resources or data types that describe patterns used by other profiles, but cannot be instantiated directly. I.e. instances can conform to profiles **based** on these abstract profiles but do not declare conformance to the abstract profiles themselves.

| | |
| :--- | :--- |
| [Medication Dispense dgMP](StructureDefinition-MedicationDispenseDgMP.md) | Dieses Profil dient ausschließlich der Validierung des Implementation Guides und ist nicht für den produktiven Einsatz gedacht. Stattdessen sollte das jeweils passende Dosage-Profil direkt in das eigene Profil eingebunden werden. |
| [Medication Request dgMP](StructureDefinition-MedicationRequestDgMP.md) | Dieses Profil dient ausschließlich der Validierung des Implementation Guides und ist nicht für den produktiven Einsatz gedacht. Stattdessen sollte das jeweils passende Dosage-Profil direkt in das eigene Profil eingebunden werden. |
| [Medication Statement dgMP](StructureDefinition-MedicationStatementDgMP.md) | Dieses Profil dient ausschließlich der Validierung des Implementation Guides und ist nicht für den produktiven Einsatz gedacht. Stattdessen sollte das jeweils passende Dosage-Profil direkt in das eigene Profil eingebunden werden. |

### Structures: Data Type Profiles 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Dosage DE](StructureDefinition-DosageDE.md) | Gibt an, wie das Medikament eingenommen oder verabreicht wurde bzw. eingenommen oder verabreicht werden soll - entweder selbst vom Patienten eingenommen oder bei Fremdverabreichung von Dritten (z. B. Leistungserbringer, Angehörige) verabreicht. |
| [Dosage dgMP](StructureDefinition-DosageDgMP.md) | Gibt an, wie das Medikament vom Patienten im Kontext dgMP eingenommen wird/wurde oder eingenommen werden soll. |
| [Timing DE](StructureDefinition-TimingDE.md) | Beschreibt ein Ereignis, das mehrfach auftreten kann. Zeitpläne werden verwendet, um festzuhalten, wann etwas geplant, erwartet oder angefordert ist. Die häufigste Anwendung ist in Dosierungsanweisungen für Medikamente. Sie werden aber auch für die Planung verschiedener Versorgungsleistungen genutzt und können zur Dokumentation von bereits erfolgten oder laufenden Aktivitäten verwendet werden. |
| [Timing dgMP](StructureDefinition-TimingDgMP.md) | Beschreibt ein Ereignis, das mehrfach auftreten kann. Zeitpläne werden verwendet, um festzuhalten, wann etwas geplant, erwartet oder angefordert ist. Die häufigste Anwendung ist in Dosierungsanweisungen für Medikamente. Sie werden aber auch für die Planung verschiedener Versorgungsleistungen genutzt und können zur Dokumentation von bereits erfolgten oder laufenden Aktivitäten verwendet werden. |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Generated Dosage Instructions Meta](StructureDefinition-GeneratedDosageInstructionsMeta.md) | Diese Extension enthält die Metainformationen zur generierten textuellen Dosierungsanweisung, die auf Basis der bereitgestellten strukturierten Dosierungsinformationen erstellt wurde. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Algorithm Language Codes dgMP ValueSet](ValueSet-AlgorithmLanguageCodesDgMP.md) | Dieses ValueSet enthält die im dgMP unterstützten Sprachen für Algorithmen, die in der Dosierung verwendet werden können. |
| [Dosage DoseQuantity ValueSet](ValueSet-DosageDoseQuantityDE.md) | Diese ValueSet enthält Konzepte für die Dosierungseinheit in der Dosiermenge. |
| [Duration UnitsOfTime dgMP ValueSet](ValueSet-DosageUnitsOfTimeDgMP.md) | Dieses ValueSet enthält dgMPV DurationUnit Zeiteinheiten aus dem UCUM-CodeSystem in deutscher Übersetzung |
| [EDQM Unit of Presentation ValueSet](ValueSet-EDQMUnitOfPresentation.md) | ValueSet Einheit der Darreichungsform gemäß EDQM, UOP, siehe https://standardterms.edqm.eu/# |
| [Period UnitsOfTime dgMP ValueSet](ValueSet-PeriodUnitsOfTimeDgMP.md) | Dieses ValueSet enthält dgMP PeriodUnit Zeiteinheiten aus dem UCUM-CodeSystem in deutscher Übersetzung |
| [Timing When dgMP](ValueSet-TimingWhenDgMP.md) | Tageszeiten für Zeitmuster |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| |
| :--- |
| [Example-MR-Bug-EmptyLists](MedicationRequest-Example-MR-Bug-EmptyLists.md) |
| [Example-MR-Bug-MultipleTimeOfDay-Daily](MedicationRequest-Example-MR-Bug-MultipleTimeOfDay-Daily.md) |
| [Example-MR-Bug-MultipleTimeOfDay-DayOfWeek](MedicationRequest-Example-MR-Bug-MultipleTimeOfDay-DayOfWeek.md) |
| [Example-MR-Bug-MultipleTimeOfDay-Interval](MedicationRequest-Example-MR-Bug-MultipleTimeOfDay-Interval.md) |
| [Example-MR-Bug-MultipleWhen-DayOfWeek](MedicationRequest-Example-MR-Bug-MultipleWhen-DayOfWeek.md) |
| [Example-MR-Bug-MultipleWhen-Interval](MedicationRequest-Example-MR-Bug-MultipleWhen-Interval.md) |
| [Example-MR-Dosage-1000](MedicationRequest-Example-MR-Dosage-1000.md) |
| [Example-MR-Dosage-1010](MedicationRequest-Example-MR-Dosage-1010.md) |
| [Example-MR-Dosage-1010-10-Days](MedicationRequest-Example-MR-Dosage-1010-10-Days.md) |
| [Example-MR-Dosage-1010-Unsorted](MedicationRequest-Example-MR-Dosage-1010-Unsorted.md) |
| [Example-MR-Dosage-10120](MedicationRequest-Example-MR-Dosage-10120.md) |
| [Example-MR-Dosage-1020](MedicationRequest-Example-MR-Dosage-1020.md) |
| [Example-MR-Dosage-1020-Unordered](MedicationRequest-Example-MR-Dosage-1020-Unordered.md) |
| [Example-MR-Dosage-1111](MedicationRequest-Example-MR-Dosage-1111.md) |
| [Example-MR-Dosage-1220](MedicationRequest-Example-MR-Dosage-1220.md) |
| [Example-MR-Dosage-Freetext](MedicationRequest-Example-MR-Dosage-Freetext.md) |
| [Example-MR-Dosage-UnitStueck-1020](MedicationRequest-Example-MR-Dosage-UnitStueck-1020.md) |
| [Example-MR-Dosage-UnitTasse-1000](MedicationRequest-Example-MR-Dosage-UnitTasse-1000.md) |
| [Example-MR-Dosage-comb-dayofweek-1](MedicationRequest-Example-MR-Dosage-comb-dayofweek-1.md) |
| [Example-MR-Dosage-comb-dayofweek-2](MedicationRequest-Example-MR-Dosage-comb-dayofweek-2.md) |
| [Example-MR-Dosage-comb-dayofweek-3](MedicationRequest-Example-MR-Dosage-comb-dayofweek-3.md) |
| [Example-MR-Dosage-comb-dayofweek-unsorted](MedicationRequest-Example-MR-Dosage-comb-dayofweek-unsorted.md) |
| [Example-MR-Dosage-comb-interval-1](MedicationRequest-Example-MR-Dosage-comb-interval-1.md) |
| [Example-MR-Dosage-comb-interval-2](MedicationRequest-Example-MR-Dosage-comb-interval-2.md) |
| [Example-MR-Dosage-comb-interval-3](MedicationRequest-Example-MR-Dosage-comb-interval-3.md) |
| [Example-MR-Dosage-comb-interval-4](MedicationRequest-Example-MR-Dosage-comb-interval-4.md) |
| [Example-MR-Dosage-interval-2d-bound](MedicationRequest-Example-MR-Dosage-interval-2d-bound.md) |
| [Example-MR-Dosage-interval-2wk](MedicationRequest-Example-MR-Dosage-interval-2wk.md) |
| [Example-MR-Dosage-interval-3d](MedicationRequest-Example-MR-Dosage-interval-3d.md) |
| [Example-MR-Dosage-interval-4times-d](MedicationRequest-Example-MR-Dosage-interval-4times-d.md) |
| [Example-MR-Dosage-interval-8d](MedicationRequest-Example-MR-Dosage-interval-8d.md) |
| [Example-MR-Dosage-tod-1t-8am](MedicationRequest-Example-MR-Dosage-tod-1t-8am.md) |
| [Example-MR-Dosage-tod-2-12am](MedicationRequest-Example-MR-Dosage-tod-2-12am.md) |
| [Example-MR-Dosage-tod-multi](MedicationRequest-Example-MR-Dosage-tod-multi.md) |
| [Example-MR-Dosage-tod-multi-bound](MedicationRequest-Example-MR-Dosage-tod-multi-bound.md) |
| [Example-MR-Dosage-tod-unsorted](MedicationRequest-Example-MR-Dosage-tod-unsorted.md) |
| [Example-MR-Dosage-weekday-2t](MedicationRequest-Example-MR-Dosage-weekday-2t.md) |
| [Example-MR-Dosage-weekday-2t-1t](MedicationRequest-Example-MR-Dosage-weekday-2t-1t.md) |
| [Example-MR-Dosage-weekday-2t-bound](MedicationRequest-Example-MR-Dosage-weekday-2t-bound.md) |
| [Example-MR-Dosage-weekday-3t](MedicationRequest-Example-MR-Dosage-weekday-3t.md) |
| [Example-MR-Dosage-weekday-unsorted](MedicationRequest-Example-MR-Dosage-weekday-unsorted.md) |
| [Example-MR-DosageTr-1000](MedicationRequest-Example-MR-DosageTr-1000.md) |
| [Invalid-C-TimingOnlyOneType-01-of-08](MedicationRequest-Invalid-C-TimingOnlyOneType-01-of-08.md) |
| [Invalid-C-TimingOnlyOneType-02-of-08](MedicationRequest-Invalid-C-TimingOnlyOneType-02-of-08.md) |
| [Invalid-C-TimingOnlyOneType-03-of-08](MedicationRequest-Invalid-C-TimingOnlyOneType-03-of-08.md) |
| [Invalid-C-TimingOnlyOneType-04-of-08](MedicationRequest-Invalid-C-TimingOnlyOneType-04-of-08.md) |
| [Invalid-C-TimingOnlyOneType-05-of-08](MedicationRequest-Invalid-C-TimingOnlyOneType-05-of-08.md) |
| [Invalid-C-TimingOnlyWhenOrTimeOfDay-01-of-01](MedicationRequest-Invalid-C-TimingOnlyWhenOrTimeOfDay-01-of-01.md) |
| [Invalid-Dosage-01-of-12-FreqPeriod-When](MedicationRequest-Invalid-Dosage-01-of-12-FreqPeriod-When.md) |
| [Invalid-Dosage-02-of-12-FreqPeriod-ToD-DayOfWeek](MedicationRequest-Invalid-Dosage-02-of-12-FreqPeriod-ToD-DayOfWeek.md) |
| [Invalid-Dosage-03-of-12-FreqPeriod-When-DayOfWeek](MedicationRequest-Invalid-Dosage-03-of-12-FreqPeriod-When-DayOfWeek.md) |
| [Invalid-Dosage-04-of-12-FreeText-and-structured](MedicationRequest-Invalid-Dosage-04-of-12-FreeText-and-structured.md) |
| [Invalid-Dosage-05-of-12-multiple-types](MedicationRequest-Invalid-Dosage-05-of-12-multiple-types.md) |
| [Invalid-Dosage-06-of-12-multiple-dosagecodes](MedicationRequest-Invalid-Dosage-06-of-12-multiple-dosagecodes.md) |
| [Invalid-Dosage-07-of-12-timing-no-dose](MedicationRequest-Invalid-Dosage-07-of-12-timing-no-dose.md) |
| [Invalid-Dosage-09-of-12-C-TimingOnlyOneTimeForInterval](MedicationRequest-Invalid-Dosage-09-of-12-C-TimingOnlyOneTimeForInterval.md) |
| [Invalid-Dosage-10-of-12-When-DiffPeriodU](MedicationRequest-Invalid-Dosage-10-of-12-When-DiffPeriodU.md) |
| [Invalid-Dosage-11-of-12-C-TimingOnlyOneWhen](MedicationRequest-Invalid-Dosage-11-of-12-C-TimingOnlyOneWhen.md) |
| [Invalid-Dosage-12-of-12-C-TimingOnlyOneDayOfWeek](MedicationRequest-Invalid-Dosage-12-of-12-C-TimingOnlyOneDayOfWeek.md) |
| [Invalid-Dosage-C-DosageDoseUnitSameCode-01-of-01](MedicationRequest-Invalid-Dosage-C-DosageDoseUnitSameCode-01-of-01.md) |
| [Invalid-Dosage-C-DosageRequiresGeneratedText-01-of-02](MedicationRequest-Invalid-Dosage-C-DosageRequiresGeneratedText-01-of-02.md) |
| [Invalid-Dosage-C-DosageRequiresGeneratedText-02-of-02](MedicationRequest-Invalid-Dosage-C-DosageRequiresGeneratedText-02-of-02.md) |
| [Invalid-Dosage-C-DosageStructuredOrFreeText-01-of-02](MedicationRequest-Invalid-Dosage-C-DosageStructuredOrFreeText-01-of-02.md) |
| [Invalid-Dosage-C-DosageStructuredOrFreeText-02-of-02](MedicationRequest-Invalid-Dosage-C-DosageStructuredOrFreeText-02-of-02.md) |
| [Invalid-Dosage-C-DosageStructuredRequiresBoth-01-of-02](MedicationRequest-Invalid-Dosage-C-DosageStructuredRequiresBoth-01-of-02.md) |
| [Invalid-Dosage-C-DosageStructuredRequiresBoth-02-of-02](MedicationRequest-Invalid-Dosage-C-DosageStructuredRequiresBoth-02-of-02.md) |
| [Invalid-Dosage-C-FreeTextMatchesRenderedText-01-of-01](MedicationRequest-Invalid-Dosage-C-FreeTextMatchesRenderedText-01-of-01.md) |
| [Invalid-Dosage-C-FreeTextSingleDosageOnly-01-of-01](MedicationRequest-Invalid-Dosage-C-FreeTextSingleDosageOnly-01-of-01.md) |
| [Invalid-Dosage-C-TimingBoundsUnitMatchesCode-01-of-01](MedicationRequest-Invalid-Dosage-C-TimingBoundsUnitMatchesCode-01-of-01.md) |
| [Invalid-Dosage-C-TimingFrequencyCount-01-of-05](MedicationRequest-Invalid-Dosage-C-TimingFrequencyCount-01-of-05.md) |
| [Invalid-Dosage-C-TimingFrequencyCount-02-of-05](MedicationRequest-Invalid-Dosage-C-TimingFrequencyCount-02-of-05.md) |
| [Invalid-Dosage-C-TimingFrequencyCount-03-of-05](MedicationRequest-Invalid-Dosage-C-TimingFrequencyCount-03-of-05.md) |
| [Invalid-Dosage-C-TimingFrequencyCount-04-of-05](MedicationRequest-Invalid-Dosage-C-TimingFrequencyCount-04-of-05.md) |
| [Invalid-Dosage-C-TimingFrequencyCount-05-of-05](MedicationRequest-Invalid-Dosage-C-TimingFrequencyCount-05-of-05.md) |
| [Invalid-Dosage-C-TimingPeriodUnit-01-of-05](MedicationRequest-Invalid-Dosage-C-TimingPeriodUnit-01-of-05.md) |
| [Invalid-Dosage-C-TimingPeriodUnit-02-of-05](MedicationRequest-Invalid-Dosage-C-TimingPeriodUnit-02-of-05.md) |
| [Invalid-Dosage-C-TimingPeriodUnit-03-of-05](MedicationRequest-Invalid-Dosage-C-TimingPeriodUnit-03-of-05.md) |
| [Invalid-Dosage-C-TimingPeriodUnit-04-of-05](MedicationRequest-Invalid-Dosage-C-TimingPeriodUnit-04-of-05.md) |
| [Invalid-Dosage-C-TimingPeriodUnit-05-of-05](MedicationRequest-Invalid-Dosage-C-TimingPeriodUnit-05-of-05.md) |
| [Invalid-Dosage-C-TimingSingleDosageForTimeOfDay-01-of-01](MedicationRequest-Invalid-Dosage-C-TimingSingleDosageForTimeOfDay-01-of-01.md) |
| [Invalid-Dosage-C-TimingSingleDosageForWhen-01-of-01](MedicationRequest-Invalid-Dosage-C-TimingSingleDosageForWhen-01-of-01.md) |
| [Invalid-multiple-01-of-10-when](MedicationRequest-Invalid-multiple-01-of-10-when.md) |
| [Invalid-multiple-02-of-10-C-TimingOnlyOneTimeOfDay](MedicationRequest-Invalid-multiple-02-of-10-C-TimingOnlyOneTimeOfDay.md) |
| [Invalid-multiple-04-of-10-C-TimingOnlyOnePeriodForDayOfWeek](MedicationRequest-Invalid-multiple-04-of-10-C-TimingOnlyOnePeriodForDayOfWeek.md) |
| [Invalid-multiple-05-of-10-C-TimingOnlyOnePeriodForDayOfWeek](MedicationRequest-Invalid-multiple-05-of-10-C-TimingOnlyOnePeriodForDayOfWeek.md) |
| [Invalid-multiple-06-of-10-C-TimingIntervalOnlyOneFrequency](MedicationRequest-Invalid-multiple-06-of-10-C-TimingIntervalOnlyOneFrequency.md) |
| [Invalid-multiple-07-of-10-C-TimingOnlyOneWhen](MedicationRequest-Invalid-multiple-07-of-10-C-TimingOnlyOneWhen.md) |
| [Invalid-multiple-08-of-10-C-TimingOnlyOneTimeOfDay](MedicationRequest-Invalid-multiple-08-of-10-C-TimingOnlyOneTimeOfDay.md) |
| [Invalid-multiple-09-of-10-C-TimingOnlyOneTimeForInterval](MedicationRequest-Invalid-multiple-09-of-10-C-TimingOnlyOneTimeForInterval.md) |
| [Invalid-multiple-10-of-10-C-TimingOnlyOneBounds](MedicationRequest-Invalid-multiple-10-of-10-C-TimingOnlyOneBounds.md) |
| [MD-Dosage-1020](MedicationDispense-MD-Dosage-1020.md) |
| [MD-Dosage-Bounds-Decimals](MedicationDispense-MD-Dosage-Bounds-Decimals.md) |
| [MD-Dosage-DayOfWeek-Time](MedicationDispense-MD-Dosage-DayOfWeek-Time.md) |
| [MD-Dosage-Freetext](MedicationDispense-MD-Dosage-Freetext.md) |
| [MD-Dosage-Interval-Time](MedicationDispense-MD-Dosage-Interval-Time.md) |
| [MR-Dosage-4schema-evening-only](MedicationRequest-MR-Dosage-4schema-evening-only.md) |
| [MR-Dosage-4schema-ml-units](MedicationRequest-MR-Dosage-4schema-ml-units.md) |
| [MR-Dosage-4schema-night-only](MedicationRequest-MR-Dosage-4schema-night-only.md) |
| [MR-Dosage-4schema-noon-only](MedicationRequest-MR-Dosage-4schema-noon-only.md) |
| [MR-Dosage-freetext-german-chars](MedicationRequest-MR-Dosage-freetext-german-chars.md) |
| [MR-Dosage-interval-monthly](MedicationRequest-MR-Dosage-interval-monthly.md) |
| [MR-Dosage-interval-when-3d](MedicationRequest-MR-Dosage-interval-when-3d.md) |
| [MR-Dosage-multiple-day-time](MedicationRequest-MR-Dosage-multiple-day-time.md) |
| [MR-Dosage-single-day-time](MedicationRequest-MR-Dosage-single-day-time.md) |
| [MR-Dosage-tod-mixed-doses](MedicationRequest-MR-Dosage-tod-mixed-doses.md) |
| [MR-Dosage-weekday-mixed-doses](MedicationRequest-MR-Dosage-weekday-mixed-doses.md) |
| [MR-Unsupported-Dosage-01-of-20-Count](MedicationRequest-MR-Unsupported-Dosage-01-of-20-Count.md) |
| [MR-Unsupported-Dosage-02-of-20-asNeededBoolean](MedicationRequest-MR-Unsupported-Dosage-02-of-20-asNeededBoolean.md) |
| [MR-Unsupported-Dosage-03-of-20-asNeededCodeableConcept](MedicationRequest-MR-Unsupported-Dosage-03-of-20-asNeededCodeableConcept.md) |
| [MR-Unsupported-Dosage-04-of-20-Method](MedicationRequest-MR-Unsupported-Dosage-04-of-20-Method.md) |
| [MR-Unsupported-Dosage-05-of-20-Route](MedicationRequest-MR-Unsupported-Dosage-05-of-20-Route.md) |
| [MR-Unsupported-Dosage-06-of-20-Site](MedicationRequest-MR-Unsupported-Dosage-06-of-20-Site.md) |
| [MR-Unsupported-Dosage-07-of-20-DoseRange](MedicationRequest-MR-Unsupported-Dosage-07-of-20-DoseRange.md) |
| [MR-Unsupported-Dosage-08-of-20-RateQuantity](MedicationRequest-MR-Unsupported-Dosage-08-of-20-RateQuantity.md) |
| [MR-Unsupported-Dosage-09-of-20-RateRange](MedicationRequest-MR-Unsupported-Dosage-09-of-20-RateRange.md) |
| [MR-Unsupported-Dosage-10-of-20-RateRatio](MedicationRequest-MR-Unsupported-Dosage-10-of-20-RateRatio.md) |
| [MR-Unsupported-Dosage-11-of-20-AdditionalInstruction](MedicationRequest-MR-Unsupported-Dosage-11-of-20-AdditionalInstruction.md) |
| [MR-Unsupported-Dosage-12-of-20-MaxDosePerPeriod](MedicationRequest-MR-Unsupported-Dosage-12-of-20-MaxDosePerPeriod.md) |
| [MR-Unsupported-Dosage-13-of-20-MaxDosePerAdministration](MedicationRequest-MR-Unsupported-Dosage-13-of-20-MaxDosePerAdministration.md) |
| [MR-Unsupported-Dosage-14-of-20-MaxDosePerLifetime](MedicationRequest-MR-Unsupported-Dosage-14-of-20-MaxDosePerLifetime.md) |
| [MR-Unsupported-Dosage-15-of-20-Count](MedicationRequest-MR-Unsupported-Dosage-15-of-20-Count.md) |
| [MR-Unsupported-Dosage-16-of-20-CountMax](MedicationRequest-MR-Unsupported-Dosage-16-of-20-CountMax.md) |
| [MR-Unsupported-Dosage-17-of-20-BoundsPeriod](MedicationRequest-MR-Unsupported-Dosage-17-of-20-BoundsPeriod.md) |
| [MR-Unsupported-Dosage-18-of-20-BoundsRange](MedicationRequest-MR-Unsupported-Dosage-18-of-20-BoundsRange.md) |
| [MR-Unsupported-Dosage-19-of-20-Offset](MedicationRequest-MR-Unsupported-Dosage-19-of-20-Offset.md) |
| [MR-Unsupported-Dosage-20-of-20-Event](MedicationRequest-MR-Unsupported-Dosage-20-of-20-Event.md) |
| [MS-Dosage-1010](MedicationStatement-MS-Dosage-1010.md) |
| [MS-Dosage-DayOfWeek](MedicationStatement-MS-Dosage-DayOfWeek.md) |
| [MS-Dosage-Freetext](MedicationStatement-MS-Dosage-Freetext.md) |
| [MS-Dosage-Interval](MedicationStatement-MS-Dosage-Interval.md) |
| [MS-Dosage-TimeOfDay](MedicationStatement-MS-Dosage-TimeOfDay.md) |
| [Warning-Dosage-Viererschema-Text-01](MedicationRequest-Warning-Dosage-Viererschema-Text-01.md) |
| [Warning-Dosage-W-DosageStructuredOrFreeTextWarning-01-of-01](MedicationRequest-Warning-Dosage-W-DosageStructuredOrFreeTextWarning-01-of-01.md) |
| [Warning-Dosage-W-DosageWarnungViererschemaInText-01-of-01](MedicationRequest-Warning-Dosage-W-DosageWarnungViererschemaInText-01-of-01.md) |

