# Dosage dgMP - Medication IG DE v1.0.1

* [**Table of Contents**](toc.md)
* [**FHIR Summary**](artifacts.md)
* **Dosage dgMP**

## Data Type Profile: Dosage dgMP 

| | |
| :--- | :--- |
| *Official URL*:http://ig.fhir.de/igs/medication/StructureDefinition/DosageDgMP | *Version*:1.0.1 |
| Active as of 2025-10-20 | *Computable Name*:DosageDgMP |

 
Gibt an, wie das Medikament vom Patienten im Kontext dgMP eingenommen wird/wurde oder eingenommen werden soll. 

## Verwendung

Dieses Profil beschreibt eine technisch streng validierte Ausprägung der FHIR-Ressource `Dosage` für den deutschen Kontext und ist speziell für den Einsatz im dgMP-Prozess entwickelt worden. Das Profil enthält gezielte Einschränkungen und Vorgaben, um die technische Überprüfbarkeit und Konsistenz von Dosierungsangaben sicherzustellen.

Hinweis für Entwickler: Verwenden Sie dieses Profil immer dann, wenn Dosierungsinformationen im Rahmen des dgMP-Prozesses erstellt oder verarbeitet werden. Insbesondere bei zentralen Diensten innerhalb der Telematikinfrastruktur (z.B. E-Rezept-Fachdienst) ist die Einhaltung dieses Profils erforderlich, da hier eine technische Validierung der Dosierung erfolgt. Beachten Sie, dass dieses Profil bewusst Einschränkungen in der Interoperabilität zugunsten der Validierbarkeit in Kauf nimmt.

**Usages:**

* Use this DataType Profile: [Medication Dispense dgMP](StructureDefinition-MedicationDispenseDgMP.md), [Medication Request dgMP](StructureDefinition-MedicationRequestDgMP.md) and [Medication Statement dgMP](StructureDefinition-MedicationStatementDgMP.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.fhir.medication|current/StructureDefinition/DosageDgMP)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-DosageDgMP.csv), [Excel](StructureDefinition-DosageDgMP.xlsx), [Schematron](StructureDefinition-DosageDgMP.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "DosageDgMP",
  "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/DosageDgMP",
  "version" : "1.0.1",
  "name" : "DosageDgMP",
  "title" : "Dosage dgMP",
  "status" : "active",
  "date" : "2025-10-20T12:04:13+02:00",
  "publisher" : "HL7 Deutschland e.V.",
  "contact" : [
    {
      "name" : "HL7 Deutschland e.V.",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.de"
        }
      ]
    }
  ],
  "description" : "Gibt an, wie das Medikament vom Patienten im Kontext dgMP eingenommen wird/wurde oder eingenommen werden soll.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "Dosage",
  "baseDefinition" : "http://ig.fhir.de/igs/medication/StructureDefinition/DosageDE",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Dosage",
        "path" : "Dosage",
        "constraint" : [
          {
            "key" : "DosageStructuredOrFreeText",
            "severity" : "error",
            "human" : "Die Dosierungsangabe darf entweder nur als Freitext oder nur als vollständige strukturierte Information erfolgen — eine Mischung ist nicht erlaubt.",
            "expression" : "(%resource.ofType(MedicationRequest).dosageInstruction | \n ofType(MedicationDispense).dosageInstruction | \n ofType(MedicationStatement).dosage).all(\n  (text.exists() and timing.empty() and doseAndRate.empty()) or\n  (text.empty() and (timing.exists() or doseAndRate.exists()))\n)\n",
            "source" : "http://ig.fhir.de/igs/medication/StructureDefinition/DosageDgMP"
          },
          {
            "key" : "DosageRequiresGeneratedText",
            "severity" : "error",
            "human" : "Unabhängig von der Art der Dosierungsangabe (strukturiert oder Freitext) müssen die Extensions GeneratedDosageInstructionsMeta und renderedDosageInstruction vorhanden sein.",
            "expression" : "\n%resource.extension.where(\n  url = 'http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta'\n).exists() and\n(\n  %resource.extension.where(\n    url = 'http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.renderedDosageInstruction'\n  ).exists() or\n  %resource.extension.where(\n    url = 'http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationDispense.renderedDosageInstruction'\n  ).exists() or\n  %resource.extension.where(\n    url = 'http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationStatement.renderedDosageInstruction'\n  ).exists()\n)\n",
            "source" : "http://ig.fhir.de/igs/medication/StructureDefinition/DosageDgMP"
          },
          {
            "key" : "FreeTextSingleDosageOnly",
            "severity" : "error",
            "human" : "Wenn eine Dosierung als reiner Freitext angegeben ist, darf nur genau ein Dosage-Element existieren.",
            "expression" : "(\n  (%resource.ofType(MedicationRequest).dosageInstruction |\n   %resource.ofType(MedicationDispense).dosageInstruction |\n   %resource.ofType(MedicationStatement).dosage\n  ).exists(text.exists() and timing.empty() and doseAndRate.empty())\n)\nimplies\n(\n  (%resource.ofType(MedicationRequest).dosageInstruction |\n   %resource.ofType(MedicationDispense).dosageInstruction |\n   %resource.ofType(MedicationStatement).dosage\n  ).count() = 1\n)",
            "source" : "http://ig.fhir.de/igs/medication/StructureDefinition/DosageDgMP"
          },
          {
            "key" : "FreeTextMatchesRenderedText",
            "severity" : "error",
            "human" : "Wenn eine Dosierung als reiner Freitext angegeben ist (text vorhanden, timing und doseAndRate leer), muss der Wert in dosageInstruction.text mit dem Wert in der Extension renderedDosageInstruction übereinstimmen.",
            "expression" : "(\n  (%resource.ofType(MedicationRequest).dosageInstruction |\n   %resource.ofType(MedicationDispense).dosageInstruction |\n   %resource.ofType(MedicationStatement).dosage\n  ).where(text.exists() and timing.empty() and doseAndRate.empty()).exists()\n)\nimplies\n(\n  (\n    %resource.ofType(MedicationRequest).exists() and\n    %resource.extension.where(\n      url = 'http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.renderedDosageInstruction'\n    ).value = %resource.dosageInstruction.text\n  ) or\n  (\n    %resource.ofType(MedicationDispense).exists() and\n    %resource.extension.where(\n      url = 'http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationDispense.renderedDosageInstruction'\n    ).value = %resource.dosageInstruction.text\n  ) or\n  (\n    %resource.ofType(MedicationStatement).exists() and\n    %resource.extension.where(\n      url = 'http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationStatement.renderedDosageInstruction'\n    ).value = %resource.dosage.text\n  )\n)",
            "source" : "http://ig.fhir.de/igs/medication/StructureDefinition/DosageDgMP"
          }
        ]
      },
      {
        "id" : "Dosage.sequence",
        "path" : "Dosage.sequence",
        "comment" : "Begründung Einschränkung Kardinalität: Eine Dosier-Sequenz ist in der ersten Ausbaustufe des dgMP nicht vorgesehen, um die Komplexität zu reduzieren und die Übersichtlichkeit zu erhöhen.",
        "max" : "0"
      },
      {
        "id" : "Dosage.additionalInstruction",
        "path" : "Dosage.additionalInstruction",
        "max" : "0"
      },
      {
        "id" : "Dosage.patientInstruction",
        "path" : "Dosage.patientInstruction",
        "max" : "0"
      },
      {
        "id" : "Dosage.timing",
        "path" : "Dosage.timing",
        "type" : [
          {
            "code" : "Timing",
            "profile" : [
              "http://ig.fhir.de/igs/medication/StructureDefinition/TimingDgMP"
            ]
          }
        ]
      },
      {
        "id" : "Dosage.asNeeded[x]",
        "path" : "Dosage.asNeeded[x]",
        "comment" : "Begründung Einschränkung Kardinalität: Eine Bedarfsdosis ist in der ersten Ausbaustufe des dgMP nicht vorgesehen, um die Komplexität zu reduzieren und die Übersichtlichkeit zu erhöhen.",
        "max" : "0"
      },
      {
        "id" : "Dosage.site",
        "path" : "Dosage.site",
        "comment" : "Begründung Einschränkung Kardinalität: Eine Verabreichungsstelle ist in der ersten Ausbaustufe des dgMP nicht vorgesehen, um die Komplexität zu reduzieren und die Übersichtlichkeit zu erhöhen.",
        "max" : "0"
      },
      {
        "id" : "Dosage.route",
        "path" : "Dosage.route",
        "comment" : "Begründung Einschränkung Kardinalität: Ein Verabreichungsweg ist in der ersten Ausbaustufe des dgMP nicht vorgesehen, um die Komplexität zu reduzieren und die Übersichtlichkeit zu erhöhen.",
        "max" : "0"
      },
      {
        "id" : "Dosage.method",
        "path" : "Dosage.method",
        "comment" : "Begründung Einschränkung Kardinalität: Eine Verabreichungsmethode ist in der ersten Ausbaustufe des dgMP nicht vorgesehen, um die Komplexität zu reduzieren und die Übersichtlichkeit zu erhöhen.",
        "max" : "0"
      },
      {
        "id" : "Dosage.doseAndRate",
        "path" : "Dosage.doseAndRate",
        "comment" : "Begründung Einschränkung Kardinalität: Nur eine Dosierung pro Medikation ist in der ersten Ausbaustufe des dgMP vorgesehen, um die Komplexität zu reduzieren und die Übersichtlichkeit zu erhöhen.",
        "max" : "1"
      },
      {
        "id" : "Dosage.doseAndRate.type",
        "path" : "Dosage.doseAndRate.type",
        "comment" : "Begründung Einschränkung Kardinalität: Eine 'type'-Angabe ist in der ersten Ausbaustufe des dgMP nicht vorgesehen, um die Komplexität zu reduzieren und die Übersichtlichkeit zu erhöhen.",
        "max" : "0"
      },
      {
        "id" : "Dosage.doseAndRate.dose[x]",
        "path" : "Dosage.doseAndRate.dose[x]",
        "comment" : "Begründung Einschränkung Datentyp: Nur einfache Mengenangaben sind in der ersten Ausbaustufe des dgMP vorgesehen, um die Komplexität zu reduzieren und die Übersichtlichkeit zu erhöhen.",
        "type" : [
          {
            "code" : "Quantity",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/SimpleQuantity"]
          }
        ]
      },
      {
        "id" : "Dosage.doseAndRate.dose[x]:doseQuantity",
        "path" : "Dosage.doseAndRate.dose[x]",
        "sliceName" : "doseQuantity",
        "type" : [
          {
            "code" : "Quantity",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/SimpleQuantity"]
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.kbv.de/ValueSet/KBV_VS_SFHIR_BMP_DOSIEREINHEIT"
        }
      },
      {
        "id" : "Dosage.doseAndRate.dose[x]:doseQuantity.unit",
        "path" : "Dosage.doseAndRate.dose[x].unit",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Dosage.doseAndRate.dose[x]:doseQuantity.system",
        "path" : "Dosage.doseAndRate.dose[x].system",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Dosage.doseAndRate.dose[x]:doseQuantity.code",
        "path" : "Dosage.doseAndRate.dose[x].code",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Dosage.doseAndRate.rate[x]",
        "path" : "Dosage.doseAndRate.rate[x]",
        "comment" : "Begründung Einschränkung Kardinalität: Eine Verabreichungsmenge pro Zeiteinheit ist in der ersten Ausbaustufe des dgMP nicht vorgesehen, um die Komplexität zu reduzieren und die Übersichtlichkeit zu erhöhen.",
        "max" : "0"
      },
      {
        "id" : "Dosage.maxDosePerPeriod",
        "path" : "Dosage.maxDosePerPeriod",
        "comment" : "Begründung Einschränkung Kardinalität: Eine maximale Dosis pro Zeitraum ist in der ersten Ausbaustufe des dgMP nicht vorgesehen, um die Komplexität zu reduzieren und die Übersichtlichkeit zu erhöhen.",
        "max" : "0"
      },
      {
        "id" : "Dosage.maxDosePerAdministration",
        "path" : "Dosage.maxDosePerAdministration",
        "comment" : "Begründung Einschränkung Kardinalität: Eine maximale Dosis pro Verabreichung ist in der ersten Ausbaustufe des dgMP nicht vorgesehen, um die Komplexität zu reduzieren und die Übersichtlichkeit zu erhöhen.",
        "max" : "0"
      },
      {
        "id" : "Dosage.maxDosePerLifetime",
        "path" : "Dosage.maxDosePerLifetime",
        "comment" : "Begründung Einschränkung Kardinalität: Eine maximale Dosis über die Lebenszeit ist in der ersten Ausbaustufe des dgMP nicht vorgesehen, um die Komplexität zu reduzieren und die Übersichtlichkeit zu erhöhen.",
        "max" : "0"
      }
    ]
  }
}

```
