# MS-Dosage-TimeOfDay - Medication IG DE v1.0.1

* [**Table of Contents**](toc.md)
* [**FHIR Summary**](artifacts.md)
* **MS-Dosage-TimeOfDay**

## Example MedicationStatement: MS-Dosage-TimeOfDay

Profile: [Medication Statement dgMP](StructureDefinition-MedicationStatementDgMP.md)

**Extension Definition for MedicationStatement.renderedDosageInstruction for Version 5.0**: 

täglich: 08:00 Uhr — je 2 Stück; 20:00 Uhr — je 1 Stück

> **Generated Dosage Instructions Meta**
* algorithmVersion: 1.0.1
* language: de-DE

**status**: Active

**medication**: Test Medication

**subject**: Patient

> **dosage****timing**: Once per 1 day

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 2 Stück(Details: UCUM code1 = '1') |


> **dosage****timing**: Once per 1 day

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 1 Stück(Details: UCUM code1 = '1') |




## Resource Content

```json
{
  "resourceType" : "MedicationStatement",
  "id" : "MS-Dosage-TimeOfDay",
  "meta" : {
    "profile" : [
      "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationStatementDgMP"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationStatement.renderedDosageInstruction",
      "valueMarkdown" : "täglich: 08:00 Uhr — je 2 Stück; 20:00 Uhr — je 1 Stück"
    },
    {
      "extension" : [
        {
          "url" : "algorithmVersion",
          "valueString" : "1.0.1"
        },
        {
          "url" : "language",
          "valueCode" : "de-DE"
        }
      ],
      "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
    }
  ],
  "status" : "active",
  "medicationCodeableConcept" : {
    "text" : "Test Medication"
  },
  "subject" : {
    "display" : "Patient"
  },
  "dosage" : [
    {
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 1,
          "periodUnit" : "d",
          "timeOfDay" : ["08:00:00"]
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 2,
            "unit" : "Stück",
            "system" : "http://unitsofmeasure.org",
            "code" : "1"
          }
        }
      ]
    },
    {
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 1,
          "periodUnit" : "d",
          "timeOfDay" : ["20:00:00"]
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 1,
            "unit" : "Stück",
            "system" : "http://unitsofmeasure.org",
            "code" : "1"
          }
        }
      ]
    }
  ]
}

```
