# Schema mit Wochentags-Bezug - Medication IG DE v1.0.1

* [**Table of Contents**](toc.md)
* **Schema mit Wochentags-Bezug**

## Schema mit Wochentags-Bezug

Dieses Schema gibt an, an welchen Wochentagen einer Kalenderwoche das Medikament angewandt werden soll.

In diesem Anwendungsfall wird davon ausgegangen, dass das Arzneimittel wöchentlich (für die geplante Dauer) in einem gleichbleibenden Wochentagsschema angewandt wird. Es wird zudem ermöglicht:

* die geplante Dauer der Anwendung zu begrenzen (bspw. in Tagen)
* eine abweichende Dosis abhängig vom Wochentag anzugeben (in einer weiteren Dosage-Instanz).

Es konkretisiert dabei nicht, zu welchem Zeitpunkt das Arzneimittel an dem betreffenden Wochentag anzuwenden ist.

Es wird ermöglicht, die geplante Dauer der Anwendung zu begrenzen.

### Beipiel

Folgende Beispiele sind in diesem IG dargestellt:

| | |
| :--- | :--- |
| Dienstags und Donnerstags je 2 Stück | [Example-MR-Dosage-weekday-2t](./MedicationRequest-Example-MR-Dosage-weekday-2t.md) |
| Unsortierte Wochentage | [Example-MR-Dosage-weekday-unsorted](./MedicationRequest-Example-MR-Dosage-weekday-unsorted.md) |
| Dienstags, Donnerstags und Samstags je 2 Stück | [Example-MR-Dosage-weekday-3t](./MedicationRequest-Example-MR-Dosage-weekday-3t.md) |
| Montags 2 Stück, Donnerstags 1 Stück | [Example-MR-Dosage-weekday-2t-1t](./MedicationRequest-Example-MR-Dosage-weekday-2t-1t.md) |
| Montags 2 Tabl. für 10 Wochen | [Example-MR-Dosage-weekday-2t-bound](./MedicationRequest-Example-MR-Dosage-weekday-2t-bound.md) |

### Angabe und Erkennung der Dosierart

Diese Dosierungsart wird daran erkannt, dass unter `Dosage.timing.repeat`

* `dayOfWeek`
* `frequency`
* `period`
* `periodUnit` in Wochen (wk)
* opt. Angabe von `bounds[x]`

angegeben ist. An diesem Feld wird dann kodiert der Wochentag angegeben an der eine konkrete Dosierung einzunehmen ist.

Folgende FHIR-Path Expression auf Ebene von `Dosage.timing.repeat` liefert die Angabe, ob es sich um das Schema handelt:

```
timing.repeat.dayOfWeek.exists() and
timing.repeat.frequency.exists() and
timing.repeat.period = 1 and
timing.repeat.periodUnit = 'wk' and
timing.repeat.when.empty() and
timing.repeat.timeOfDay.empty()

```

Der Wert von frequency entspricht dabei der Anzahl an Elementen in `dayOfWeek`.

Soll das Arzneimittel in derselben Dosierung an mehreren Tagen angewandt werden, wird dies über mehrere Angaben von `dayOfWeek` ausgedrückt. Die angegebene Dosierung ist dann zu jedem der genannten Tage anzuwenden.

Beispiel:

* Dosage.timing.repeat.dayOfWeek = "mon", "fri"
* Dosage.doseAndRate.doseQuantity = 1 Stück bedeutet, dass eine Stück jeweils am Montag und Freitag einzunehmen ist.

Lesende Systeme werten entsprechend auch `Dosage.timing.repeat` aus. Wenn nur .dayOfWeek angegeben ist, ist dem Nutzer anzuzeigen, dass die Dosierung nach Wochentagen definiert ist.

