# FHIR Implementation Guide für medikationsbezogene Anwendungsfälle im deutschen Gesundheitswesen - Medication IG DE v1.0.1

* [**Table of Contents**](toc.md)
* **FHIR Implementation Guide für medikationsbezogene Anwendungsfälle im deutschen Gesundheitswesen**

## FHIR Implementation Guide für medikationsbezogene Anwendungsfälle im deutschen Gesundheitswesen

| | |
| :--- | :--- |
| *Official URL*:http://ig.fhir.de/igs/medication/ImplementationGuide/de.fhir.medication | *Version*:1.0.1 |
| Active as of 2025-10-20 | *Computable Name*:MedicationDE |

### Kurzbeschreibung

Dieser Implementation Guide (IG) beschreibt die standardisierte und interoperable Abbildung medikationsbezogener Informationen und Prozesse im deutschen Gesundheitswesen auf Basis von HL7® FHIR®. Ziel ist es, sektorenübergreifende Anwendungsfälle - wie beispielsweise die strukturierte Dosierungsinformation im E-Rezept, den elektronischen Medikationsplan oder den Austausch mittels [ISiK](https://fachportal.gematik.de/informationen-fuer/isik/bestaetigungsverfahren-isik) - zu ermöglichen und zu harmonisieren.

Der IG enthält die Beschreibung der jeweiligen Anwendungsfälle sowie begleitende Dokumentation.

### Aktuelle Anwendungsfälle

Dieser Implementation Guide wird kontinuierlich weiterentwickelt und verbessert. Aktuell werden folgende Anwendungsfälle unterstützt:

* Strukturierte und textuelle Darstellung von [Dosierungen](./dosierung-einfuehrung.md)

### Must Support

Elemente mit der Eigenschaft [mustSupport](https://www.hl7.org/fhir/profiling.html#mustsupport) müssen immer implementiert werden. Hierbei handelt es sich um Elemente, die unabhängig von der Kardinalität (Ausnahme: 0…0) unterstützt werden müssen, sofern die entsprechenden Informationen vorliegen.

Die Software, welche die Dateien erstellt, muss die mit „mustSupport“ gekennzeichneten Elemente (mustSupport value="true") unterstützen - befüllen und übermitteln können.

Die Software, welche die Dateien verarbeitet, muss die mit „mustSupport“ gekennzeichneten Elemente (mustSupport value="true") unterstützen - auslesen und verarbeiten können.

### Zielgruppen

* Softwarehersteller und Systemintegratoren im Gesundheitswesen
* Entwickler:innen von FHIR-basierten Systemen
* Ärzt:innen, Apotheker:innen, Pflegekräfte
* Fachexpert:innen für Interoperabilität und Arzneimitteltherapie

### Mitwirkende Organisationen

Durch Input und Feedback haben folgende Organisationen an der Erstellung dieses Implementation Guides mitgewirkt:

* Bundesvereinigung Deutscher Apothekerverbände
* Deutscher Apothekerverband
* Deutsche Krankenhausgesellschaft
* gematik GmbH
* GKV-Spitzenverband
* HL7 Deutschland
* Kassenärztliche Bundesvereinigung
* Kompetenzzentrum für Interoperabilität im Gesundheitswesen (KIG)
* Verband der Privaten Krankenversicherung

### Abhängigkeiten

Dieser IG verwendet zur Kodierung der doseQuantity [KBV_VS_SFHIR_BMP_DOSIEREINHEIT](https://fhir.kbv.de/ValueSet/KBV_VS_SFHIR_BMP_DOSIEREINHEIT) & [KBV_CS_SFHIR_BMP_DOSIEREINHEIT](https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT) welche bewusst nicht als Abhängigkeit deklariert worden sind.



### Kontakt und Feedback

Für Fragen und Feedback wenden Sie sich bitte an [info@hl7.de](mailto:info@hl7.de) oder nutzen Sie das [GitHub-Repository](https://github.com/hl7germany/medication-ig-de-r4/issues).

### Rechtliche Hinweise

Dieser Implementation Guide wurde in Zusammenarbeit zwischen

* [HL7 Deutschland e.V.](https://hl7.de/)
* [gematik GmbH](https://www.gematik.de/)

erarbeitet.

Copyright © 2025 HL7 Deutschland e.V.

HL7®, HEALTH LEVEL SEVEN®, FHIR® und das FHIR®-Logo sind Marken von Health Level Seven International, eingetragen beim United States Patent and Trademark Office.



## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "de.fhir.medication",
  "url" : "http://ig.fhir.de/igs/medication/ImplementationGuide/de.fhir.medication",
  "version" : "1.0.1",
  "name" : "MedicationDE",
  "title" : "Medication IG DE",
  "status" : "active",
  "date" : "2025-10-20T12:04:13+02:00",
  "publisher" : "HL7 Deutschland e.V.",
  "contact" : [
    {
      "name" : "HL7 Deutschland e.V.",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.de"
        }
      ]
    }
  ],
  "packageId" : "de.fhir.medication",
  "license" : "CC0-1.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "6.5.0"
    },
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2025+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "STU1"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://ig.fhir.de/igs/medication/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.8.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2025+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "STU1"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://ig.fhir.de/igs/medication/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/AlgorithmLanguageCodesDgMP"
        },
        "name" : "Algorithm Language Codes dgMP ValueSet",
        "description" : "Dieses ValueSet enthält die im dgMP unterstützten Sprachen für Algorithmen, die in der Dosierung verwendet werden können.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/DosageDE"
        },
        "name" : "Dosage DE",
        "description" : "Gibt an, wie das Medikament eingenommen oder verabreicht wurde bzw. eingenommen oder verabreicht werden soll - entweder selbst vom Patienten eingenommen oder bei Fremdverabreichung von Dritten (z. B. Leistungserbringer, Angehörige) verabreicht.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/DosageDgMP"
        },
        "name" : "Dosage dgMP",
        "description" : "Gibt an, wie das Medikament vom Patienten im Kontext dgMP eingenommen wird/wurde oder eingenommen werden soll.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/DosageDoseQuantityDE"
        },
        "name" : "Dosage DoseQuantity ValueSet",
        "description" : "Diese ValueSet enthält Konzepte für die Dosierungseinheit in der Dosiermenge.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/DosageUnitsOfTimeDgMP"
        },
        "name" : "Duration UnitsOfTime dgMP ValueSet",
        "description" : "Dieses ValueSet enthält dgMPV DurationUnit Zeiteinheiten aus dem UCUM-CodeSystem in deutscher Übersetzung",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/EDQMUnitOfPresentation"
        },
        "name" : "EDQM Unit of Presentation ValueSet",
        "description" : "ValueSet Einheit der Darreichungsform gemäß EDQM, UOP, siehe https://standardterms.edqm.eu/#",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Bug-EmptyLists"
        },
        "name" : "Example-MR-Bug-EmptyLists",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Bug-MultipleTimeOfDay-Daily"
        },
        "name" : "Example-MR-Bug-MultipleTimeOfDay-Daily",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Bug-MultipleTimeOfDay-DayOfWeek"
        },
        "name" : "Example-MR-Bug-MultipleTimeOfDay-DayOfWeek",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Bug-MultipleTimeOfDay-Interval"
        },
        "name" : "Example-MR-Bug-MultipleTimeOfDay-Interval",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Bug-MultipleWhen-DayOfWeek"
        },
        "name" : "Example-MR-Bug-MultipleWhen-DayOfWeek",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Bug-MultipleWhen-Interval"
        },
        "name" : "Example-MR-Bug-MultipleWhen-Interval",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-1000"
        },
        "name" : "Example-MR-Dosage-1000",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-1010"
        },
        "name" : "Example-MR-Dosage-1010",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-1010-10-Days"
        },
        "name" : "Example-MR-Dosage-1010-10-Days",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-1010-Unsorted"
        },
        "name" : "Example-MR-Dosage-1010-Unsorted",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-10120"
        },
        "name" : "Example-MR-Dosage-10120",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-1020"
        },
        "name" : "Example-MR-Dosage-1020",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-1020-Unordered"
        },
        "name" : "Example-MR-Dosage-1020-Unordered",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-1111"
        },
        "name" : "Example-MR-Dosage-1111",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-1220"
        },
        "name" : "Example-MR-Dosage-1220",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-comb-dayofweek-1"
        },
        "name" : "Example-MR-Dosage-comb-dayofweek-1",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-comb-dayofweek-2"
        },
        "name" : "Example-MR-Dosage-comb-dayofweek-2",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-comb-dayofweek-3"
        },
        "name" : "Example-MR-Dosage-comb-dayofweek-3",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-comb-dayofweek-unsorted"
        },
        "name" : "Example-MR-Dosage-comb-dayofweek-unsorted",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-comb-interval-1"
        },
        "name" : "Example-MR-Dosage-comb-interval-1",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-comb-interval-2"
        },
        "name" : "Example-MR-Dosage-comb-interval-2",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-comb-interval-3"
        },
        "name" : "Example-MR-Dosage-comb-interval-3",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-comb-interval-4"
        },
        "name" : "Example-MR-Dosage-comb-interval-4",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-Freetext"
        },
        "name" : "Example-MR-Dosage-Freetext",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-interval-2d-bound"
        },
        "name" : "Example-MR-Dosage-interval-2d-bound",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-interval-2wk"
        },
        "name" : "Example-MR-Dosage-interval-2wk",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-interval-3d"
        },
        "name" : "Example-MR-Dosage-interval-3d",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-interval-4times-d"
        },
        "name" : "Example-MR-Dosage-interval-4times-d",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-interval-8d"
        },
        "name" : "Example-MR-Dosage-interval-8d",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-tod-1t-8am"
        },
        "name" : "Example-MR-Dosage-tod-1t-8am",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-tod-2-12am"
        },
        "name" : "Example-MR-Dosage-tod-2-12am",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-tod-multi"
        },
        "name" : "Example-MR-Dosage-tod-multi",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-tod-multi-bound"
        },
        "name" : "Example-MR-Dosage-tod-multi-bound",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-tod-unsorted"
        },
        "name" : "Example-MR-Dosage-tod-unsorted",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-UnitStueck-1020"
        },
        "name" : "Example-MR-Dosage-UnitStueck-1020",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-UnitTasse-1000"
        },
        "name" : "Example-MR-Dosage-UnitTasse-1000",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-weekday-2t"
        },
        "name" : "Example-MR-Dosage-weekday-2t",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-weekday-2t-1t"
        },
        "name" : "Example-MR-Dosage-weekday-2t-1t",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-weekday-2t-bound"
        },
        "name" : "Example-MR-Dosage-weekday-2t-bound",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-weekday-3t"
        },
        "name" : "Example-MR-Dosage-weekday-3t",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-weekday-unsorted"
        },
        "name" : "Example-MR-Dosage-weekday-unsorted",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-DosageTr-1000"
        },
        "name" : "Example-MR-DosageTr-1000",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/GeneratedDosageInstructionsMeta"
        },
        "name" : "Generated Dosage Instructions Meta",
        "description" : "Diese Extension enthält die Metainformationen zur generierten textuellen Dosierungsanweisung, die auf Basis der bereitgestellten strukturierten Dosierungsinformationen erstellt wurde.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-C-TimingOnlyOneType-01-of-08"
        },
        "name" : "Invalid-C-TimingOnlyOneType-01-of-08",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-C-TimingOnlyOneType-02-of-08"
        },
        "name" : "Invalid-C-TimingOnlyOneType-02-of-08",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-C-TimingOnlyOneType-03-of-08"
        },
        "name" : "Invalid-C-TimingOnlyOneType-03-of-08",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-C-TimingOnlyOneType-04-of-08"
        },
        "name" : "Invalid-C-TimingOnlyOneType-04-of-08",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-C-TimingOnlyOneType-05-of-08"
        },
        "name" : "Invalid-C-TimingOnlyOneType-05-of-08",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-C-TimingOnlyWhenOrTimeOfDay-01-of-01"
        },
        "name" : "Invalid-C-TimingOnlyWhenOrTimeOfDay-01-of-01",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-01-of-12-FreqPeriod-When"
        },
        "name" : "Invalid-Dosage-01-of-12-FreqPeriod-When",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-02-of-12-FreqPeriod-ToD-DayOfWeek"
        },
        "name" : "Invalid-Dosage-02-of-12-FreqPeriod-ToD-DayOfWeek",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-03-of-12-FreqPeriod-When-DayOfWeek"
        },
        "name" : "Invalid-Dosage-03-of-12-FreqPeriod-When-DayOfWeek",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-04-of-12-FreeText-and-structured"
        },
        "name" : "Invalid-Dosage-04-of-12-FreeText-and-structured",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-05-of-12-multiple-types"
        },
        "name" : "Invalid-Dosage-05-of-12-multiple-types",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-06-of-12-multiple-dosagecodes"
        },
        "name" : "Invalid-Dosage-06-of-12-multiple-dosagecodes",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-07-of-12-timing-no-dose"
        },
        "name" : "Invalid-Dosage-07-of-12-timing-no-dose",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-09-of-12-C-TimingOnlyOneTimeForInterval"
        },
        "name" : "Invalid-Dosage-09-of-12-C-TimingOnlyOneTimeForInterval",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-10-of-12-When-DiffPeriodU"
        },
        "name" : "Invalid-Dosage-10-of-12-When-DiffPeriodU",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-11-of-12-C-TimingOnlyOneWhen"
        },
        "name" : "Invalid-Dosage-11-of-12-C-TimingOnlyOneWhen",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-12-of-12-C-TimingOnlyOneDayOfWeek"
        },
        "name" : "Invalid-Dosage-12-of-12-C-TimingOnlyOneDayOfWeek",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-DosageDoseUnitSameCode-01-of-01"
        },
        "name" : "Invalid-Dosage-C-DosageDoseUnitSameCode-01-of-01",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-DosageRequiresGeneratedText-01-of-02"
        },
        "name" : "Invalid-Dosage-C-DosageRequiresGeneratedText-01-of-02",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-DosageRequiresGeneratedText-02-of-02"
        },
        "name" : "Invalid-Dosage-C-DosageRequiresGeneratedText-02-of-02",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-DosageStructuredOrFreeText-01-of-02"
        },
        "name" : "Invalid-Dosage-C-DosageStructuredOrFreeText-01-of-02",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-DosageStructuredOrFreeText-02-of-02"
        },
        "name" : "Invalid-Dosage-C-DosageStructuredOrFreeText-02-of-02",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-DosageStructuredRequiresBoth-01-of-02"
        },
        "name" : "Invalid-Dosage-C-DosageStructuredRequiresBoth-01-of-02",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-DosageStructuredRequiresBoth-02-of-02"
        },
        "name" : "Invalid-Dosage-C-DosageStructuredRequiresBoth-02-of-02",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-FreeTextMatchesRenderedText-01-of-01"
        },
        "name" : "Invalid-Dosage-C-FreeTextMatchesRenderedText-01-of-01",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-FreeTextSingleDosageOnly-01-of-01"
        },
        "name" : "Invalid-Dosage-C-FreeTextSingleDosageOnly-01-of-01",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-TimingBoundsUnitMatchesCode-01-of-01"
        },
        "name" : "Invalid-Dosage-C-TimingBoundsUnitMatchesCode-01-of-01",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-TimingFrequencyCount-01-of-05"
        },
        "name" : "Invalid-Dosage-C-TimingFrequencyCount-01-of-05",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-TimingFrequencyCount-02-of-05"
        },
        "name" : "Invalid-Dosage-C-TimingFrequencyCount-02-of-05",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-TimingFrequencyCount-03-of-05"
        },
        "name" : "Invalid-Dosage-C-TimingFrequencyCount-03-of-05",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-TimingFrequencyCount-04-of-05"
        },
        "name" : "Invalid-Dosage-C-TimingFrequencyCount-04-of-05",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-TimingFrequencyCount-05-of-05"
        },
        "name" : "Invalid-Dosage-C-TimingFrequencyCount-05-of-05",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-TimingPeriodUnit-01-of-05"
        },
        "name" : "Invalid-Dosage-C-TimingPeriodUnit-01-of-05",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-TimingPeriodUnit-02-of-05"
        },
        "name" : "Invalid-Dosage-C-TimingPeriodUnit-02-of-05",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-TimingPeriodUnit-03-of-05"
        },
        "name" : "Invalid-Dosage-C-TimingPeriodUnit-03-of-05",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-TimingPeriodUnit-04-of-05"
        },
        "name" : "Invalid-Dosage-C-TimingPeriodUnit-04-of-05",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-TimingPeriodUnit-05-of-05"
        },
        "name" : "Invalid-Dosage-C-TimingPeriodUnit-05-of-05",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-TimingSingleDosageForTimeOfDay-01-of-01"
        },
        "name" : "Invalid-Dosage-C-TimingSingleDosageForTimeOfDay-01-of-01",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-TimingSingleDosageForWhen-01-of-01"
        },
        "name" : "Invalid-Dosage-C-TimingSingleDosageForWhen-01-of-01",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-multiple-01-of-10-when"
        },
        "name" : "Invalid-multiple-01-of-10-when",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-multiple-02-of-10-C-TimingOnlyOneTimeOfDay"
        },
        "name" : "Invalid-multiple-02-of-10-C-TimingOnlyOneTimeOfDay",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-multiple-04-of-10-C-TimingOnlyOnePeriodForDayOfWeek"
        },
        "name" : "Invalid-multiple-04-of-10-C-TimingOnlyOnePeriodForDayOfWeek",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-multiple-05-of-10-C-TimingOnlyOnePeriodForDayOfWeek"
        },
        "name" : "Invalid-multiple-05-of-10-C-TimingOnlyOnePeriodForDayOfWeek",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-multiple-06-of-10-C-TimingIntervalOnlyOneFrequency"
        },
        "name" : "Invalid-multiple-06-of-10-C-TimingIntervalOnlyOneFrequency",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-multiple-07-of-10-C-TimingOnlyOneWhen"
        },
        "name" : "Invalid-multiple-07-of-10-C-TimingOnlyOneWhen",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-multiple-08-of-10-C-TimingOnlyOneTimeOfDay"
        },
        "name" : "Invalid-multiple-08-of-10-C-TimingOnlyOneTimeOfDay",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-multiple-09-of-10-C-TimingOnlyOneTimeForInterval"
        },
        "name" : "Invalid-multiple-09-of-10-C-TimingOnlyOneTimeForInterval",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-multiple-10-of-10-C-TimingOnlyOneBounds"
        },
        "name" : "Invalid-multiple-10-of-10-C-TimingOnlyOneBounds",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/MD-Dosage-1020"
        },
        "name" : "MD-Dosage-1020",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationDispenseDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/MD-Dosage-Bounds-Decimals"
        },
        "name" : "MD-Dosage-Bounds-Decimals",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationDispenseDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/MD-Dosage-DayOfWeek-Time"
        },
        "name" : "MD-Dosage-DayOfWeek-Time",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationDispenseDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/MD-Dosage-Freetext"
        },
        "name" : "MD-Dosage-Freetext",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationDispenseDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/MD-Dosage-Interval-Time"
        },
        "name" : "MD-Dosage-Interval-Time",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationDispenseDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource:abstract"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MedicationDispenseDgMP"
        },
        "name" : "Medication Dispense dgMP",
        "description" : "Dieses Profil dient ausschließlich der Validierung des Implementation Guides und ist nicht für den produktiven Einsatz gedacht. Stattdessen sollte das jeweils passende Dosage-Profil direkt in das eigene Profil eingebunden werden.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource:abstract"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MedicationRequestDgMP"
        },
        "name" : "Medication Request dgMP",
        "description" : "Dieses Profil dient ausschließlich der Validierung des Implementation Guides und ist nicht für den produktiven Einsatz gedacht. Stattdessen sollte das jeweils passende Dosage-Profil direkt in das eigene Profil eingebunden werden.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource:abstract"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MedicationStatementDgMP"
        },
        "name" : "Medication Statement dgMP",
        "description" : "Dieses Profil dient ausschließlich der Validierung des Implementation Guides und ist nicht für den produktiven Einsatz gedacht. Stattdessen sollte das jeweils passende Dosage-Profil direkt in das eigene Profil eingebunden werden.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Dosage-4schema-evening-only"
        },
        "name" : "MR-Dosage-4schema-evening-only",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Dosage-4schema-ml-units"
        },
        "name" : "MR-Dosage-4schema-ml-units",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Dosage-4schema-night-only"
        },
        "name" : "MR-Dosage-4schema-night-only",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Dosage-4schema-noon-only"
        },
        "name" : "MR-Dosage-4schema-noon-only",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Dosage-freetext-german-chars"
        },
        "name" : "MR-Dosage-freetext-german-chars",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Dosage-interval-monthly"
        },
        "name" : "MR-Dosage-interval-monthly",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Dosage-interval-when-3d"
        },
        "name" : "MR-Dosage-interval-when-3d",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Dosage-multiple-day-time"
        },
        "name" : "MR-Dosage-multiple-day-time",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Dosage-single-day-time"
        },
        "name" : "MR-Dosage-single-day-time",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Dosage-tod-mixed-doses"
        },
        "name" : "MR-Dosage-tod-mixed-doses",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Dosage-weekday-mixed-doses"
        },
        "name" : "MR-Dosage-weekday-mixed-doses",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-01-of-20-Count"
        },
        "name" : "MR-Unsupported-Dosage-01-of-20-Count",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-02-of-20-asNeededBoolean"
        },
        "name" : "MR-Unsupported-Dosage-02-of-20-asNeededBoolean",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-03-of-20-asNeededCodeableConcept"
        },
        "name" : "MR-Unsupported-Dosage-03-of-20-asNeededCodeableConcept",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-04-of-20-Method"
        },
        "name" : "MR-Unsupported-Dosage-04-of-20-Method",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-05-of-20-Route"
        },
        "name" : "MR-Unsupported-Dosage-05-of-20-Route",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-06-of-20-Site"
        },
        "name" : "MR-Unsupported-Dosage-06-of-20-Site",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-07-of-20-DoseRange"
        },
        "name" : "MR-Unsupported-Dosage-07-of-20-DoseRange",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-08-of-20-RateQuantity"
        },
        "name" : "MR-Unsupported-Dosage-08-of-20-RateQuantity",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-09-of-20-RateRange"
        },
        "name" : "MR-Unsupported-Dosage-09-of-20-RateRange",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-10-of-20-RateRatio"
        },
        "name" : "MR-Unsupported-Dosage-10-of-20-RateRatio",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-11-of-20-AdditionalInstruction"
        },
        "name" : "MR-Unsupported-Dosage-11-of-20-AdditionalInstruction",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-12-of-20-MaxDosePerPeriod"
        },
        "name" : "MR-Unsupported-Dosage-12-of-20-MaxDosePerPeriod",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-13-of-20-MaxDosePerAdministration"
        },
        "name" : "MR-Unsupported-Dosage-13-of-20-MaxDosePerAdministration",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-14-of-20-MaxDosePerLifetime"
        },
        "name" : "MR-Unsupported-Dosage-14-of-20-MaxDosePerLifetime",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-15-of-20-Count"
        },
        "name" : "MR-Unsupported-Dosage-15-of-20-Count",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-16-of-20-CountMax"
        },
        "name" : "MR-Unsupported-Dosage-16-of-20-CountMax",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-17-of-20-BoundsPeriod"
        },
        "name" : "MR-Unsupported-Dosage-17-of-20-BoundsPeriod",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-18-of-20-BoundsRange"
        },
        "name" : "MR-Unsupported-Dosage-18-of-20-BoundsRange",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-19-of-20-Offset"
        },
        "name" : "MR-Unsupported-Dosage-19-of-20-Offset",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-20-of-20-Event"
        },
        "name" : "MR-Unsupported-Dosage-20-of-20-Event",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/MS-Dosage-1010"
        },
        "name" : "MS-Dosage-1010",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationStatementDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/MS-Dosage-DayOfWeek"
        },
        "name" : "MS-Dosage-DayOfWeek",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationStatementDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/MS-Dosage-Freetext"
        },
        "name" : "MS-Dosage-Freetext",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationStatementDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/MS-Dosage-Interval"
        },
        "name" : "MS-Dosage-Interval",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationStatementDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/MS-Dosage-TimeOfDay"
        },
        "name" : "MS-Dosage-TimeOfDay",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationStatementDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/PeriodUnitsOfTimeDgMP"
        },
        "name" : "Period UnitsOfTime dgMP ValueSet",
        "description" : "Dieses ValueSet enthält dgMP PeriodUnit Zeiteinheiten aus dem UCUM-CodeSystem in deutscher Übersetzung",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/TimingDE"
        },
        "name" : "Timing DE",
        "description" : "Beschreibt ein Ereignis, das mehrfach auftreten kann. Zeitpläne werden verwendet, um festzuhalten, wann etwas geplant, erwartet oder angefordert ist. Die häufigste Anwendung ist in Dosierungsanweisungen für Medikamente. Sie werden aber auch für die Planung verschiedener Versorgungsleistungen genutzt und können zur Dokumentation von bereits erfolgten oder laufenden Aktivitäten verwendet werden.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/TimingDgMP"
        },
        "name" : "Timing dgMP",
        "description" : "Beschreibt ein Ereignis, das mehrfach auftreten kann. Zeitpläne werden verwendet, um festzuhalten, wann etwas geplant, erwartet oder angefordert ist. Die häufigste Anwendung ist in Dosierungsanweisungen für Medikamente. Sie werden aber auch für die Planung verschiedener Versorgungsleistungen genutzt und können zur Dokumentation von bereits erfolgten oder laufenden Aktivitäten verwendet werden.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/TimingWhenDgMP"
        },
        "name" : "Timing When dgMP",
        "description" : "Tageszeiten für Zeitmuster",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Warning-Dosage-Viererschema-Text-01"
        },
        "name" : "Warning-Dosage-Viererschema-Text-01",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Warning-Dosage-W-DosageStructuredOrFreeTextWarning-01-of-01"
        },
        "name" : "Warning-Dosage-W-DosageStructuredOrFreeTextWarning-01-of-01",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Warning-Dosage-W-DosageWarnungViererschemaInText-01-of-01"
        },
        "name" : "Warning-Dosage-W-DosageWarnungViererschemaInText-01-of-01",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "FHIR Implementation Guide für medikationsbezogene Anwendungsfälle im deutschen Gesundheitswesen",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "dosierung-einfuehrung.html"
            }
          ],
          "nameUrl" : "dosierung-einfuehrung.html",
          "title" : "FHIR Dosierungen für den digital gestützten Medikationsprozess",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "dosierung-rahmenvorgaben.html"
            }
          ],
          "nameUrl" : "dosierung-rahmenvorgaben.html",
          "title" : "Fachliche Rahmenvorgaben für Dosierungen",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "dosierung-dgmp.html"
            }
          ],
          "nameUrl" : "dosierung-dgmp.html",
          "title" : "Fachliche Rahmenvorgaben des dgMP",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "dosierung-textgenerierung.html"
            }
          ],
          "nameUrl" : "dosierung-textgenerierung.html",
          "title" : "Dosis Textgenerierung",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "dosierung-text-hinzufuegen.html"
            }
          ],
          "nameUrl" : "dosierung-text-hinzufuegen.html",
          "title" : "Bereitstellung des Dosierungstextes",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "dosierung-constraints.html"
            }
          ],
          "nameUrl" : "dosierung-constraints.html",
          "title" : "Übersicht der Timing & Dosierungs-Invarianten",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "schema-freitext.html"
            }
          ],
          "nameUrl" : "schema-freitext.html",
          "title" : "Freitext-Dosierung",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "schema-tageszeit.html"
            }
          ],
          "nameUrl" : "schema-tageszeit.html",
          "title" : "Schema mit Tageszeiten-Bezug",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "schema-uhrzeit.html"
            }
          ],
          "nameUrl" : "schema-uhrzeit.html",
          "title" : "Schema mit Uhrzeiten-Bezug",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "schema-wochentag.html"
            }
          ],
          "nameUrl" : "schema-wochentag.html",
          "title" : "Schema mit Wochentags-Bezug",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "schema-intervall.html"
            }
          ],
          "nameUrl" : "schema-intervall.html",
          "title" : "Schema für wiederkehrende Intervalle",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "schema-intervall-kombination.html"
            }
          ],
          "nameUrl" : "schema-intervall-kombination.html",
          "title" : "Schema für Kombinationen von Zeitintervallen",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "schema-wochentag-kombination.html"
            }
          ],
          "nameUrl" : "schema-wochentag-kombination.html",
          "title" : "Schema für Kombinationen von Wochentagen",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "dosierung-beispiele.html"
            }
          ],
          "nameUrl" : "dosierung-beispiele.html",
          "title" : "Beispielliste Dosierung",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "artifacts.html"
            }
          ],
          "nameUrl" : "artifacts.html",
          "title" : "FHIR Summary",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads.html"
            }
          ],
          "nameUrl" : "downloads.html",
          "title" : "Downloads",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-pages",
        "value" : "input/content"
      },
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/maps"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
