# Timing dgMP - Medication IG DE v1.0.1

* [**Table of Contents**](toc.md)
* [**FHIR Summary**](artifacts.md)
* **Timing dgMP**

## Data Type Profile: Timing dgMP 

| | |
| :--- | :--- |
| *Official URL*:http://ig.fhir.de/igs/medication/StructureDefinition/TimingDgMP | *Version*:1.0.1 |
| Active as of 2025-10-20 | *Computable Name*:TimingDgMP |

 
Beschreibt ein Ereignis, das mehrfach auftreten kann. Zeitpläne werden verwendet, um festzuhalten, wann etwas geplant, erwartet oder angefordert ist. Die häufigste Anwendung ist in Dosierungsanweisungen für Medikamente. Sie werden aber auch für die Planung verschiedener Versorgungsleistungen genutzt und können zur Dokumentation von bereits erfolgten oder laufenden Aktivitäten verwendet werden. 

**Usages:**

* Use this DataType Profile: [Dosage dgMP](StructureDefinition-DosageDgMP.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.fhir.medication|current/StructureDefinition/TimingDgMP)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-TimingDgMP.csv), [Excel](StructureDefinition-TimingDgMP.xlsx), [Schematron](StructureDefinition-TimingDgMP.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "TimingDgMP",
  "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/TimingDgMP",
  "version" : "1.0.1",
  "name" : "TimingDgMP",
  "title" : "Timing dgMP",
  "status" : "active",
  "date" : "2025-10-20T12:04:13+02:00",
  "publisher" : "HL7 Deutschland e.V.",
  "contact" : [
    {
      "name" : "HL7 Deutschland e.V.",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.de"
        }
      ]
    }
  ],
  "description" : "Beschreibt ein Ereignis, das mehrfach auftreten kann. Zeitpläne werden verwendet, um festzuhalten, wann etwas geplant, erwartet oder angefordert ist. Die häufigste Anwendung ist in Dosierungsanweisungen für Medikamente. Sie werden aber auch für die Planung verschiedener Versorgungsleistungen genutzt und können zur Dokumentation von bereits erfolgten oder laufenden Aktivitäten verwendet werden.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "Timing",
  "baseDefinition" : "http://ig.fhir.de/igs/medication/StructureDefinition/TimingDE",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Timing.event",
        "path" : "Timing.event",
        "comment" : "Begründung Einschränkung Kardinalität: Der Zeitpunkt des Ereignisses ist in der ersten Ausbaustufe des dgMP nicht vorgesehen, um die Komplexität zu reduzieren und die Übersichtlichkeit zu erhöhen.",
        "max" : "0"
      },
      {
        "id" : "Timing.repeat",
        "path" : "Timing.repeat",
        "min" : 1,
        "constraint" : [
          {
            "key" : "TimingOnlyOneType",
            "severity" : "error",
            "human" : "Only one kind of Timing is allowed. Current allowed timings: 4-Scheme, TimeOfDay, DayOfWeek, Interval, DayOfWeek and Time/4-Schema, Interval and Time/4-Schema",
            "expression" : "/* DayOfWeek */\n(\n  %resource.ofType(MedicationRequest).dosageInstruction | \n  ofType(MedicationDispense).dosageInstruction | \n  ofType(MedicationStatement).dosage\n).all(\n  timing.repeat.dayOfWeek.exists() and\n  timing.repeat.frequency.exists() and\n  (timing.repeat.period.exists() and timing.repeat.period = 1) and\n  (timing.repeat.periodUnit.exists()) and\n  timing.repeat.when.empty() and\n  timing.repeat.timeOfDay.empty()\n) or\n\n/* Interval */\n(\n  %resource.ofType(MedicationRequest).dosageInstruction | \n  ofType(MedicationDispense).dosageInstruction | \n  ofType(MedicationStatement).dosage\n).all(\n  timing.repeat.frequency.exists() and\n  timing.repeat.period.exists() and\n  timing.repeat.periodUnit.exists() and\n  timing.repeat.when.empty() and\n  timing.repeat.timeOfDay.empty() and\n  timing.repeat.dayOfWeek.empty()\n) or\n\n/* DayOfWeek and Time/4-Schema */\n(\n  %resource.ofType(MedicationRequest).dosageInstruction | \n  ofType(MedicationDispense).dosageInstruction | \n  ofType(MedicationStatement).dosage\n).all(\n  timing.repeat.dayOfWeek.exists() and\n  timing.repeat.frequency.exists() and\n  (timing.repeat.period.exists() and timing.repeat.period = 1) and\n  (timing.repeat.periodUnit.exists()) and\n  (\n    (timing.repeat.timeOfDay.exists() and timing.repeat.when.empty()) or\n    (timing.repeat.when.exists() and timing.repeat.timeOfDay.empty())\n  )\n) or\n\n/* Interval and Time/4-Schema */\n(\n  %resource.ofType(MedicationRequest).dosageInstruction | \n  ofType(MedicationDispense).dosageInstruction | \n  ofType(MedicationStatement).dosage\n).all(\n  timing.repeat.frequency.exists() and\n  timing.repeat.period.exists() and\n  timing.repeat.periodUnit.exists() and\n  timing.repeat.dayOfWeek.empty() and\n  (\n    (timing.repeat.timeOfDay.exists() and timing.repeat.when.empty()) or\n    (timing.repeat.when.exists() and timing.repeat.timeOfDay.empty())\n  )\n)\n",
            "source" : "http://ig.fhir.de/igs/medication/StructureDefinition/TimingDgMP"
          },
          {
            "key" : "TimingIntervalOnlyOneFrequency",
            "severity" : "error",
            "human" : "If a dosage is defined by a pure interval, then only one dosage is allowed in the resource.",
            "expression" : "( /* Detect Interval */\n  %resource.ofType(MedicationRequest).dosageInstruction\n  | %resource.ofType(MedicationDispense).dosageInstruction\n  | %resource.ofType(MedicationStatement).dosage\n)\n.all(\n  (\n    timing.repeat.frequency.exists()\n    and timing.repeat.period.exists()\n    and timing.repeat.periodUnit.exists()\n    and timing.repeat.when.empty()\n    and timing.repeat.timeOfDay.empty()\n    and timing.repeat.dayOfWeek.empty()\n  )\n  /* Only One Dosage allowed for Interval */\n  implies\n  (\n    (\n      (\n        %resource.ofType(MedicationRequest).exists()\n        or %resource.ofType(MedicationDispense).exists()\n      )\n      implies (\n        %resource.dosageInstruction.count() = 1\n      )\n    )\n    and\n    (\n      %resource.ofType(MedicationStatement).exists()\n      implies\n      %resource.dosage.count() = 1\n    )\n  )\n)\n",
            "source" : "http://ig.fhir.de/igs/medication/StructureDefinition/TimingDgMP"
          },
          {
            "key" : "TimingOnlyOneWhen",
            "severity" : "error",
            "human" : "Dosages Timings must not state the same period of day across multiple dosage instances",
            "expression" : "( /* Detect 4-Schema */\n  %resource.ofType(MedicationRequest).dosageInstruction\n  | %resource.ofType(MedicationDispense).dosageInstruction\n  | %resource.ofType(MedicationStatement).dosage\n).all(\n    timing.repeat.frequency.exists() and\n    timing.repeat.period.exists() and\n    timing.repeat.periodUnit.exists() and\n    timing.repeat.dayOfWeek.empty() and\n    timing.repeat.when.exists() and \n    timing.repeat.timeOfDay.empty()\n  implies\n  (\n    (\n      (%resource.ofType(MedicationRequest).exists() or %resource.ofType(MedicationDispense).exists())\n      implies\n      (%resource.dosageInstruction.timing.repeat.when.distinct().count() = %resource.dosageInstruction.timing.repeat.when.count())\n    )\n    and\n    (\n      %resource.ofType(MedicationStatement).exists()\n      implies\n      (%resource.dosage.timing.repeat.when.distinct().count() = %resource.dosage.timing.repeat.when.count())\n    )\n  )\n)\n",
            "source" : "http://ig.fhir.de/igs/medication/StructureDefinition/TimingDgMP"
          },
          {
            "key" : "TimingOnlyWhenOrTimeOfDay",
            "severity" : "error",
            "human" : "Dosages Timings must not state a time of day and period of day across multiple dosage instances",
            "expression" : "(\n  %resource.ofType(MedicationRequest).dosageInstruction\n  | %resource.ofType(MedicationDispense).dosageInstruction\n  | %resource.ofType(MedicationStatement).dosage\n).all(\n    timing.repeat.frequency.exists() and\n    timing.repeat.period.exists() and\n    timing.repeat.periodUnit.exists() and\n    timing.repeat.dayOfWeek.empty() and\n    (timing.repeat.when.exists() or \n    timing.repeat.timeOfDay.exists())\n  implies\n  (\n    (\n      (%resource.ofType(MedicationRequest).exists() or %resource.ofType(MedicationDispense).exists())\n      implies\n      (%resource.dosageInstruction.timing.repeat.when.exists() xor %resource.dosageInstruction.timing.repeat.timeOfDay.exists())\n    )\n    and\n    (\n      %resource.ofType(MedicationStatement).exists()\n      implies\n      (%resource.dosage.timing.repeat.when.exists() xor %resource.dosage.timing.repeat.timeOfDay.exists())\n    )\n  )\n)\n",
            "source" : "http://ig.fhir.de/igs/medication/StructureDefinition/TimingDgMP"
          },
          {
            "key" : "TimingOnlyOneTimeOfDay",
            "severity" : "error",
            "human" : "Dosages Timings must not state the same time of day across multiple dosage instances",
            "expression" : "( /* Detect TimeOfDay */\n  %resource.ofType(MedicationRequest).dosageInstruction\n  | %resource.ofType(MedicationDispense).dosageInstruction\n  | %resource.ofType(MedicationStatement).dosage\n).all(\n  (\n    timing.repeat.frequency.exists() and\n    timing.repeat.period.exists() and\n    timing.repeat.periodUnit.exists() and\n    timing.repeat.dayOfWeek.empty() and\n    timing.repeat.timeOfDay.exists() and\n    timing.repeat.when.empty() \n  )\n  implies\n  (\n    (\n      (%resource.ofType(MedicationRequest).exists() or %resource.ofType(MedicationDispense).exists())\n      implies\n      (%resource.dosageInstruction.timing.repeat.timeOfDay.distinct().count() = %resource.dosageInstruction.timing.repeat.timeOfDay.count())\n    )\n    and\n    (\n      %resource.ofType(MedicationStatement).exists()\n      implies\n      (%resource.dosage.timing.repeat.timeOfDay.distinct().count() = %resource.dosage.timing.repeat.timeOfDay.count())\n    )\n  )\n)",
            "source" : "http://ig.fhir.de/igs/medication/StructureDefinition/TimingDgMP"
          },
          {
            "key" : "TimingOnlyOneDayOfWeek",
            "severity" : "error",
            "human" : "Dosages Timings must not state the same day across multiple dosage instances",
            "expression" : "( /* Detect DayOfWeek */\n  %resource.ofType(MedicationRequest).dosageInstruction\n  | %resource.ofType(MedicationDispense).dosageInstruction\n  | %resource.ofType(MedicationStatement).dosage\n).all(\n  (\n    timing.repeat.frequency.exists() and\n    timing.repeat.period.exists() and\n    timing.repeat.periodUnit.exists() and\n    timing.repeat.dayOfWeek.exists() and\n    timing.repeat.when.empty() and \n    timing.repeat.timeOfDay.empty()\n  )\n  implies\n  (\n    (\n      (%resource.ofType(MedicationRequest).exists() or %resource.ofType(MedicationDispense).exists())\n      implies\n      (%resource.dosageInstruction.timing.repeat.dayOfWeek.distinct().count() = %resource.dosageInstruction.timing.repeat.dayOfWeek.count())\n    )\n    and\n    (\n      %resource.ofType(MedicationStatement).exists()\n      implies\n      (%resource.dosage.timing.repeat.dayOfWeek.distinct().count() = %resource.dosage.timing.repeat.dayOfWeek.count())\n    )\n  )\n)",
            "source" : "http://ig.fhir.de/igs/medication/StructureDefinition/TimingDgMP"
          },
          {
            "key" : "TimingOnlyOnePeriodForDayOfWeek",
            "severity" : "error",
            "human" : "For schedules using only dayOfWeek with either timeOfDay or when, each (day + period of day/time) combination must be unique across all dosage instructions.",
            "expression" : "( /* Detect DayOfWeek and Time/4-Schema */\n  %resource.ofType(MedicationRequest).dosageInstruction\n  | %resource.ofType(MedicationDispense).dosageInstruction\n  | %resource.ofType(MedicationStatement).dosage\n).all(\n  (\n    timing.repeat.dayOfWeek.exists() and\n    timing.repeat.frequency.exists() and\n    timing.repeat.period.exists() and\n    timing.repeat.periodUnit.exists() and\n      (\n        (timing.repeat.timeOfDay.exists() and timing.repeat.when.empty()) or\n        (timing.repeat.when.exists() and timing.repeat.timeOfDay.empty())\n      )\n  )\n  implies\n  (\n    (\n      (%resource.ofType(MedicationRequest).exists() or %resource.ofType(MedicationDispense).exists())\n      implies\n      (\n        /* For each day of week */\n        /* if Mon occurs multiple times */\n        ((\n          %resource.dosageInstruction.timing.repeat.dayOfWeek\n          .where($this = 'mon')\n          .where(%resource.dosageInstruction.timing.repeat.dayOfWeek.where($this = 'mon').count() > 1)\n          .distinct()\n        ) implies \n        (\n          (%resource.dosageInstruction.timing.repeat.where('mon' in dayOfWeek).when.distinct().count() = %resource.dosageInstruction.timing.repeat.where('mon' in dayOfWeek).when.count()) and\n          (%resource.dosageInstruction.timing.repeat.where('mon' in dayOfWeek).timeOfDay.distinct().count() = %resource.dosageInstruction.timing.repeat.where('mon' in dayOfWeek).timeOfDay.count())\n        )) and\n        \n        /* if tue occurs multiple times */\n        ((\n          %resource.dosageInstruction.timing.repeat.dayOfWeek\n          .where($this = 'tue')\n          .where(%resource.dosageInstruction.timing.repeat.dayOfWeek.where($this = 'tue').count() > 1)\n          .distinct()\n        ) implies \n        (\n          (%resource.dosageInstruction.timing.repeat.where('tue' in dayOfWeek).when.distinct().count() = %resource.dosageInstruction.timing.repeat.where('tue' in dayOfWeek).when.count()) and\n          (%resource.dosageInstruction.timing.repeat.where('tue' in dayOfWeek).timeOfDay.distinct().count() = %resource.dosageInstruction.timing.repeat.where('tue' in dayOfWeek).timeOfDay.count())\n        )) and\n        /* if wed occurs multiple times */\n        ((\n          %resource.dosageInstruction.timing.repeat.dayOfWeek\n          .where($this = 'wed')\n          .where(%resource.dosageInstruction.timing.repeat.dayOfWeek.where($this = 'wed').count() > 1)\n          .distinct()\n        ) implies \n        (\n          (%resource.dosageInstruction.timing.repeat.where('wed' in dayOfWeek).when.distinct().count() = %resource.dosageInstruction.timing.repeat.where('wed' in dayOfWeek).when.count()) and\n          (%resource.dosageInstruction.timing.repeat.where('wed' in dayOfWeek).timeOfDay.distinct().count() = %resource.dosageInstruction.timing.repeat.where('wed' in dayOfWeek).timeOfDay.count())\n        )) and\n        /* if thu occurs multiple times */\n        ((\n          %resource.dosageInstruction.timing.repeat.dayOfWeek\n          .where($this = 'thu')\n          .where(%resource.dosageInstruction.timing.repeat.dayOfWeek.where($this = 'thu').count() > 1)\n          .distinct()\n        ) implies \n        (\n          (%resource.dosageInstruction.timing.repeat.where('thu' in dayOfWeek).when.distinct().count() = %resource.dosageInstruction.timing.repeat.where('thu' in dayOfWeek).when.count()) and\n          (%resource.dosageInstruction.timing.repeat.where('thu' in dayOfWeek).timeOfDay.distinct().count() = %resource.dosageInstruction.timing.repeat.where('thu' in dayOfWeek).timeOfDay.count())\n        )) and\n        /* if fri occurs multiple times */\n        ((\n          %resource.dosageInstruction.timing.repeat.dayOfWeek\n          .where($this = 'fri')\n          .where(%resource.dosageInstruction.timing.repeat.dayOfWeek.where($this = 'fri').count() > 1)\n          .distinct()\n        ) implies \n        (\n          (%resource.dosageInstruction.timing.repeat.where('fri' in dayOfWeek).when.distinct().count() = %resource.dosageInstruction.timing.repeat.where('fri' in dayOfWeek).when.count()) and\n          (%resource.dosageInstruction.timing.repeat.where('fri' in dayOfWeek).timeOfDay.distinct().count() = %resource.dosageInstruction.timing.repeat.where('fri' in dayOfWeek).timeOfDay.count())\n        )) and\n        /* if sat occurs multiple times */\n        ((\n          %resource.dosageInstruction.timing.repeat.dayOfWeek\n          .where($this = 'sat')\n          .where(%resource.dosageInstruction.timing.repeat.dayOfWeek.where($this = 'sat').count() > 1)\n          .distinct()\n        ) implies \n        (\n          (%resource.dosageInstruction.timing.repeat.where('sat' in dayOfWeek).when.distinct().count() = %resource.dosageInstruction.timing.repeat.where('sat' in dayOfWeek).when.count()) and\n          (%resource.dosageInstruction.timing.repeat.where('sat' in dayOfWeek).timeOfDay.distinct().count() = %resource.dosageInstruction.timing.repeat.where('sat' in dayOfWeek).timeOfDay.count())\n        )) and\n        \n        /* if sun occurs multiple times */\n        ((\n          %resource.dosageInstruction.timing.repeat.dayOfWeek\n          .where($this = 'sun')\n          .where(%resource.dosageInstruction.timing.repeat.dayOfWeek.where($this = 'sun').count() > 1)\n          .distinct()\n        ) implies \n        (\n          (%resource.dosageInstruction.timing.repeat.where('sun' in dayOfWeek).when.distinct().count() = %resource.dosageInstruction.timing.repeat.where('sun' in dayOfWeek).when.count()) and\n          (%resource.dosageInstruction.timing.repeat.where('sun' in dayOfWeek).timeOfDay.distinct().count() = %resource.dosageInstruction.timing.repeat.where('sun' in dayOfWeek).timeOfDay.count())\n        ))\n      )\n    )\n    and\n    (\n      %resource.ofType(MedicationStatement).exists()\n      implies\n      (\n        /* For each day of week */\n        /* if Mon occurs multiple times */\n        ((\n          %resource.dosage.timing.repeat.dayOfWeek\n          .where($this = 'mon')\n          .where(%resource.dosage.timing.repeat.dayOfWeek.where($this = 'mon').count() > 1)\n          .distinct()\n        ) implies \n        (\n          (%resource.dosage.timing.repeat.where('mon' in dayOfWeek).when.distinct().count() = %resource.dosage.timing.repeat.where('mon' in dayOfWeek).when.count()) and\n          (%resource.dosage.timing.repeat.where('mon' in dayOfWeek).timeOfDay.distinct().count() = %resource.dosage.timing.repeat.where('mon' in dayOfWeek).timeOfDay.count())\n        )) and\n        \n        /* if tue occurs multiple times */\n        ((\n          %resource.dosage.timing.repeat.dayOfWeek\n          .where($this = 'tue')\n          .where(%resource.dosage.timing.repeat.dayOfWeek.where($this = 'tue').count() > 1)\n          .distinct()\n        ) implies \n        (\n          (%resource.dosage.timing.repeat.where('tue' in dayOfWeek).when.distinct().count() = %resource.dosage.timing.repeat.where('tue' in dayOfWeek).when.count()) and\n          (%resource.dosage.timing.repeat.where('tue' in dayOfWeek).timeOfDay.distinct().count() = %resource.dosage.timing.repeat.where('tue' in dayOfWeek).timeOfDay.count())\n        )) and\n        /* if wed occurs multiple times */\n        ((\n          %resource.dosage.timing.repeat.dayOfWeek\n          .where($this = 'wed')\n          .where(%resource.dosage.timing.repeat.dayOfWeek.where($this = 'wed').count() > 1)\n          .distinct()\n        ) implies \n        (\n          (%resource.dosage.timing.repeat.where('wed' in dayOfWeek).when.distinct().count() = %resource.dosage.timing.repeat.where('wed' in dayOfWeek).when.count()) and\n          (%resource.dosage.timing.repeat.where('wed' in dayOfWeek).timeOfDay.distinct().count() = %resource.dosage.timing.repeat.where('wed' in dayOfWeek).timeOfDay.count())\n        )) and\n        /* if thu occurs multiple times */\n        ((\n          %resource.dosage.timing.repeat.dayOfWeek\n          .where($this = 'thu')\n          .where(%resource.dosage.timing.repeat.dayOfWeek.where($this = 'thu').count() > 1)\n          .distinct()\n        ) implies \n        (\n          (%resource.dosage.timing.repeat.where('thu' in dayOfWeek).when.distinct().count() = %resource.dosage.timing.repeat.where('thu' in dayOfWeek).when.count()) and\n          (%resource.dosage.timing.repeat.where('thu' in dayOfWeek).timeOfDay.distinct().count() = %resource.dosage.timing.repeat.where('thu' in dayOfWeek).timeOfDay.count())\n        )) and\n        /* if fri occurs multiple times */\n        ((\n          %resource.dosage.timing.repeat.dayOfWeek\n          .where($this = 'fri')\n          .where(%resource.dosage.timing.repeat.dayOfWeek.where($this = 'fri').count() > 1)\n          .distinct()\n        ) implies \n        (\n          (%resource.dosage.timing.repeat.where('fri' in dayOfWeek).when.distinct().count() = %resource.dosage.timing.repeat.where('fri' in dayOfWeek).when.count()) and\n          (%resource.dosage.timing.repeat.where('fri' in dayOfWeek).timeOfDay.distinct().count() = %resource.dosage.timing.repeat.where('fri' in dayOfWeek).timeOfDay.count())\n        )) and\n        /* if sat occurs multiple times */\n        ((\n          %resource.dosage.timing.repeat.dayOfWeek\n          .where($this = 'sat')\n          .where(%resource.dosage.timing.repeat.dayOfWeek.where($this = 'sat').count() > 1)\n          .distinct()\n        ) implies \n        (\n          (%resource.dosage.timing.repeat.where('sat' in dayOfWeek).when.distinct().count() = %resource.dosage.timing.repeat.where('sat' in dayOfWeek).when.count()) and\n          (%resource.dosage.timing.repeat.where('sat' in dayOfWeek).timeOfDay.distinct().count() = %resource.dosage.timing.repeat.where('sat' in dayOfWeek).timeOfDay.count())\n        )) and\n        \n        /* if sun occurs multiple times */\n        ((\n          %resource.dosage.timing.repeat.dayOfWeek\n          .where($this = 'sun')\n          .where(%resource.dosage.timing.repeat.dayOfWeek.where($this = 'sun').count() > 1)\n          .distinct()\n        ) implies \n        (\n          (%resource.dosage.timing.repeat.where('sun' in dayOfWeek).when.distinct().count() = %resource.dosage.timing.repeat.where('sun' in dayOfWeek).when.count()) and\n          (%resource.dosage.timing.repeat.where('sun' in dayOfWeek).timeOfDay.distinct().count() = %resource.dosage.timing.repeat.where('sun' in dayOfWeek).timeOfDay.count())\n        ))\n      )\n    )\n  )\n)",
            "source" : "http://ig.fhir.de/igs/medication/StructureDefinition/TimingDgMP"
          },
          {
            "key" : "TimingOnlyOneTimeForInterval",
            "severity" : "error",
            "human" : "Dosage Interval Timings must not state the same time of day across multiple dosage instances",
            "expression" : "/* Detect Interval and Time/4-Schema */\n(\n  %resource.ofType(MedicationRequest).dosageInstruction\n  | %resource.ofType(MedicationDispense).dosageInstruction\n  | %resource.ofType(MedicationStatement).dosage\n)\n.all(\n  (\n    timing.repeat.frequency.exists() and\n    timing.repeat.period.exists() and\n    timing.repeat.periodUnit.exists() and\n    timing.repeat.dayOfWeek.empty() and\n    (\n      (timing.repeat.timeOfDay.exists() and timing.repeat.when.empty()) or\n      (timing.repeat.when.exists() and timing.repeat.timeOfDay.empty())\n    )\n  )\n  implies\n  (\n    (\n      %resource.ofType(MedicationRequest).exists()\n      or %resource.ofType(MedicationDispense).exists()\n    )\n    implies\n    (\n      %resource.dosageInstruction.timing.repeat.period.distinct().count() = 1\n      and %resource.dosageInstruction.timing.repeat.periodUnit.distinct().count() = 1\n    )\n    and\n    (\n      (%resource.dosageInstruction.timing.repeat.timeOfDay.distinct().count() = %resource.dosageInstruction.timing.repeat.timeOfDay.count())\n      and\n      (%resource.dosageInstruction.timing.repeat.when.distinct().count() = %resource.dosageInstruction.timing.repeat.when.count())\n    )\n  )\n  and\n  (\n    %resource.ofType(MedicationStatement).exists()\n    implies\n    (\n      (\n        %resource.ofType(MedicationRequest).exists()\n        or %resource.ofType(MedicationDispense).exists()\n      )\n      implies\n      (\n        %resource.dosage.timing.repeat.period.distinct().count() = 1\n        and %resource.dosage.timing.repeat.periodUnit.distinct().count() = 1\n      )\n      and\n      (\n        (%resource.dosage.timing.repeat.timeOfDay.distinct().count() = %resource.dosage.timing.repeat.timeOfDay.count())\n        and\n        (%resource.dosage.timing.repeat.when.distinct().count() = %resource.dosage.timing.repeat.when.count())\n      )\n    )\n  )\n)\n",
            "source" : "http://ig.fhir.de/igs/medication/StructureDefinition/TimingDgMP"
          },
          {
            "key" : "TimingOnlyOneBounds",
            "severity" : "error",
            "human" : "Dosages Timings must state the same bounds duration across multiple dosage instances",
            "expression" : "(\n  %resource.ofType(MedicationRequest).dosageInstruction\n  | %resource.ofType(MedicationDispense).dosageInstruction\n  | %resource.ofType(MedicationStatement).dosage\n).all(\n  (\n    ( /* only one different value and code are allowed*/\n      (%resource.ofType(MedicationRequest).exists() or %resource.ofType(MedicationDispense).exists())\n      implies\n      %resource.dosageInstruction.timing.repeat.bounds.ofType(Duration).exists().not() or\n      (\n        (%resource.dosageInstruction.timing.repeat.bounds.ofType(Duration).value.distinct().count() = 1)\n        and\n        (%resource.dosageInstruction.timing.repeat.bounds.ofType(Duration).code.distinct().count() = 1)\n      )\n    )\n    and\n    (\n      %resource.ofType(MedicationStatement).exists()\n      implies\n      %resource.dosage.timing.repeat.bounds.ofType(Duration).exists().not() or\n      (\n        (%resource.dosage.timing.repeat.bounds.ofType(Duration).value.distinct().count() = 1)\n        and\n        (%resource.dosage.timing.repeat.bounds.ofType(Duration).code.distinct().count() = 1)\n      )\n    )\n  )\n)",
            "source" : "http://ig.fhir.de/igs/medication/StructureDefinition/TimingDgMP"
          },
          {
            "key" : "TimingFrequencyCount",
            "severity" : "error",
            "human" : "The frequency of the timing needs to reflect the count of timeOfDay or when",
            "expression" : "(when.exists() and dayOfWeek.empty() implies when.count() = frequency)\nand\n(when.exists() and dayOfWeek.exists() implies (when.count() * dayOfWeek.count()) = frequency)\nand\n(timeOfDay.exists() and dayOfWeek.empty() implies timeOfDay.count() = frequency)\nand\n(timeOfDay.exists() and dayOfWeek.exists() implies (timeOfDay.count() * dayOfWeek.count()) = frequency)\nand\n(dayOfWeek.exists() and timeOfDay.empty() and when.empty() implies dayOfWeek.count() = frequency)",
            "source" : "http://ig.fhir.de/igs/medication/StructureDefinition/TimingDgMP"
          },
          {
            "key" : "TimingPeriodUnit",
            "severity" : "error",
            "human" : "If weekdays are given the periodUnit must be week, otherwise day",
            "expression" : "(dayOfWeek.exists() implies periodUnit = 'wk')\nand\n((dayOfWeek.empty() and (when.exists() or timeOfDay.exists())) implies periodUnit = 'd')",
            "source" : "http://ig.fhir.de/igs/medication/StructureDefinition/TimingDgMP"
          }
        ]
      },
      {
        "id" : "Timing.repeat.bounds[x]",
        "path" : "Timing.repeat.bounds[x]",
        "comment" : "Begründung Einschränkung Datentyp: Nur eine Angabe zur Dauer ist in der ersten Ausbaustufe des dgMP vorgesehen, um die Komplexität zu reduzieren und die Übersichtlichkeit zu erhöhen.",
        "type" : [
          {
            "code" : "Duration"
          }
        ]
      },
      {
        "id" : "Timing.repeat.bounds[x]:boundsDuration",
        "path" : "Timing.repeat.bounds[x]",
        "sliceName" : "boundsDuration",
        "type" : [
          {
            "code" : "Duration"
          }
        ]
      },
      {
        "id" : "Timing.repeat.bounds[x]:boundsDuration.value",
        "path" : "Timing.repeat.bounds[x].value",
        "min" : 1
      },
      {
        "id" : "Timing.repeat.bounds[x]:boundsDuration.comparator",
        "path" : "Timing.repeat.bounds[x].comparator",
        "max" : "0"
      },
      {
        "id" : "Timing.repeat.bounds[x]:boundsDuration.unit",
        "path" : "Timing.repeat.bounds[x].unit",
        "min" : 1
      },
      {
        "id" : "Timing.repeat.bounds[x]:boundsDuration.system",
        "path" : "Timing.repeat.bounds[x].system",
        "min" : 1
      },
      {
        "id" : "Timing.repeat.bounds[x]:boundsDuration.code",
        "path" : "Timing.repeat.bounds[x].code",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://ig.fhir.de/igs/medication/ValueSet/DosageUnitsOfTimeDgMP"
        }
      },
      {
        "id" : "Timing.repeat.count",
        "path" : "Timing.repeat.count",
        "comment" : "Begründung Einschränkung Kardinalität: Wiederholungen sind in der ersten Ausbaustufe des dgMP nicht vorgesehen, um die Komplexität zu reduzieren und die Übersichtlichkeit zu erhöhen.",
        "max" : "0"
      },
      {
        "id" : "Timing.repeat.countMax",
        "path" : "Timing.repeat.countMax",
        "comment" : "Begründung Einschränkung Kardinalität: Maximale Wiederholungen sind in der ersten Ausbaustufe des dgMP nicht vorgesehen, um die Komplexität zu reduzieren und die Übersichtlichkeit zu erhöhen.",
        "max" : "0"
      },
      {
        "id" : "Timing.repeat.duration",
        "path" : "Timing.repeat.duration",
        "comment" : "Begründung Einschränkung Kardinalität: Angaben zur Dauer einer Einzelgabe sind in der ersten Ausbaustufe des dgMP nicht vorgesehen, um die Komplexität zu reduzieren und die Übersichtlichkeit zu erhöhen.",
        "max" : "0"
      },
      {
        "id" : "Timing.repeat.durationMax",
        "path" : "Timing.repeat.durationMax",
        "comment" : "Begründung Einschränkung Kardinalität: Angaben zur maximalen Dauer einer Einzelgabe sind in der ersten Ausbaustufe desdgMP nicht vorgesehen, um die Komplexität zu reduzieren und die Übersichtlichkeit zu erhöhen.",
        "max" : "0"
      },
      {
        "id" : "Timing.repeat.durationUnit",
        "path" : "Timing.repeat.durationUnit",
        "comment" : "Begründung Einschränkung Kardinalität: Angaben zur Einheit der Dauer einer Einzelgabe sind in der ersten Ausbaustufe desdgMP nicht vorgesehen, um die Komplexität zu reduzieren und die Übersichtlichkeit zu erhöhen.",
        "max" : "0"
      },
      {
        "id" : "Timing.repeat.frequency",
        "path" : "Timing.repeat.frequency",
        "min" : 1
      },
      {
        "id" : "Timing.repeat.frequencyMax",
        "path" : "Timing.repeat.frequencyMax",
        "comment" : "Begründung Einschränkung Kardinalität: Eine maximale Frequenz ist in der ersten Ausbaustufe des dgMP nicht vorgesehen - es wird immer eine Frequenz explizit gesetzt, um die Komplexität zu reduzieren und die Übersichtlichkeit zu erhöhen.",
        "max" : "0"
      },
      {
        "id" : "Timing.repeat.period",
        "path" : "Timing.repeat.period",
        "min" : 1
      },
      {
        "id" : "Timing.repeat.periodMax",
        "path" : "Timing.repeat.periodMax",
        "comment" : "Begründung Einschränkung Kardinalität: Eine maximale Periodendauer ist in der ersten Ausbaustufe des dgMP nicht vorgesehen - es wird immer eine Dauer explizit gesetzt, um die Komplexität zu reduzieren und die Übersichtlichkeit zu erhöhen.",
        "max" : "0"
      },
      {
        "id" : "Timing.repeat.periodUnit",
        "path" : "Timing.repeat.periodUnit",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://ig.fhir.de/igs/medication/ValueSet/PeriodUnitsOfTimeDgMP"
        }
      },
      {
        "id" : "Timing.repeat.when",
        "path" : "Timing.repeat.when",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://ig.fhir.de/igs/medication/ValueSet/TimingWhenDgMP"
        }
      },
      {
        "id" : "Timing.repeat.offset",
        "path" : "Timing.repeat.offset",
        "short" : "Zeitversatz",
        "comment" : "Begründung Einschränkung Kardinalität: Ein Zeitversatz ist in der ersten Ausbaustufe desdgMP nicht vorgesehen, um die Komplexität zu reduzieren und die Übersichtlichkeit zu erhöhen.",
        "max" : "0"
      },
      {
        "id" : "Timing.code",
        "path" : "Timing.code",
        "comment" : "Begründung Einschränkung Kardinalität: Ein Timing-Code ist in der ersten Ausbaustufe des dgMP nicht vorgesehen, um die Komplexität zu reduzieren und die Übersichtlichkeit zu erhöhen. Stattdessen muss das Zeitmuster explizit strukturiert angegeben werden.",
        "max" : "0"
      }
    ]
  }
}

```
