# Medication Request dgMP - Medication IG DE v1.0.1

* [**Table of Contents**](toc.md)
* [**FHIR Summary**](artifacts.md)
* **Medication Request dgMP**

## Resource Profile: Medication Request dgMP ( Abstract ) 

| | |
| :--- | :--- |
| *Official URL*:http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP | *Version*:1.0.1 |
| Active as of 2025-10-20 | *Computable Name*:MedicationRequestDgMP |

 
Dieses Profil dient ausschließlich der Validierung des Implementation Guides und ist nicht für den produktiven Einsatz gedacht. Stattdessen sollte das jeweils passende Dosage-Profil direkt in das eigene Profil eingebunden werden. 

## Verwendung

Dieses Profil dient ausschließlich der Validierung des Implementation Guides und ist nicht für den produktiven Einsatz gedacht

**Usages:**

* Examples for this Profile: [MedicationRequest/Example-MR-Bug-EmptyLists](MedicationRequest-Example-MR-Bug-EmptyLists.md), [MedicationRequest/Example-MR-Bug-MultipleTimeOfDay-Daily](MedicationRequest-Example-MR-Bug-MultipleTimeOfDay-Daily.md), [MedicationRequest/Example-MR-Bug-MultipleTimeOfDay-DayOfWeek](MedicationRequest-Example-MR-Bug-MultipleTimeOfDay-DayOfWeek.md), [MedicationRequest/Example-MR-Bug-MultipleTimeOfDay-Interval](MedicationRequest-Example-MR-Bug-MultipleTimeOfDay-Interval.md)...Show 46 more,[MedicationRequest/Example-MR-Bug-MultipleWhen-DayOfWeek](MedicationRequest-Example-MR-Bug-MultipleWhen-DayOfWeek.md),[MedicationRequest/Example-MR-Bug-MultipleWhen-Interval](MedicationRequest-Example-MR-Bug-MultipleWhen-Interval.md),[MedicationRequest/Example-MR-Dosage-1000](MedicationRequest-Example-MR-Dosage-1000.md),[MedicationRequest/Example-MR-Dosage-1010-10-Days](MedicationRequest-Example-MR-Dosage-1010-10-Days.md),[MedicationRequest/Example-MR-Dosage-1010-Unsorted](MedicationRequest-Example-MR-Dosage-1010-Unsorted.md),[MedicationRequest/Example-MR-Dosage-1010](MedicationRequest-Example-MR-Dosage-1010.md),[MedicationRequest/Example-MR-Dosage-10120](MedicationRequest-Example-MR-Dosage-10120.md),[MedicationRequest/Example-MR-Dosage-1020-Unordered](MedicationRequest-Example-MR-Dosage-1020-Unordered.md),[MedicationRequest/Example-MR-Dosage-1020](MedicationRequest-Example-MR-Dosage-1020.md),[MedicationRequest/Example-MR-Dosage-1111](MedicationRequest-Example-MR-Dosage-1111.md),[MedicationRequest/Example-MR-Dosage-1220](MedicationRequest-Example-MR-Dosage-1220.md),[MedicationRequest/Example-MR-Dosage-Freetext](MedicationRequest-Example-MR-Dosage-Freetext.md),[MedicationRequest/Example-MR-Dosage-UnitStueck-1020](MedicationRequest-Example-MR-Dosage-UnitStueck-1020.md),[MedicationRequest/Example-MR-Dosage-UnitTasse-1000](MedicationRequest-Example-MR-Dosage-UnitTasse-1000.md),[MedicationRequest/Example-MR-Dosage-comb-dayofweek-1](MedicationRequest-Example-MR-Dosage-comb-dayofweek-1.md),[MedicationRequest/Example-MR-Dosage-comb-dayofweek-2](MedicationRequest-Example-MR-Dosage-comb-dayofweek-2.md),[MedicationRequest/Example-MR-Dosage-comb-dayofweek-3](MedicationRequest-Example-MR-Dosage-comb-dayofweek-3.md),[MedicationRequest/Example-MR-Dosage-comb-dayofweek-unsorted](MedicationRequest-Example-MR-Dosage-comb-dayofweek-unsorted.md),[MedicationRequest/Example-MR-Dosage-comb-interval-1](MedicationRequest-Example-MR-Dosage-comb-interval-1.md),[MedicationRequest/Example-MR-Dosage-comb-interval-2](MedicationRequest-Example-MR-Dosage-comb-interval-2.md),[MedicationRequest/Example-MR-Dosage-comb-interval-3](MedicationRequest-Example-MR-Dosage-comb-interval-3.md),[MedicationRequest/Example-MR-Dosage-comb-interval-4](MedicationRequest-Example-MR-Dosage-comb-interval-4.md),[MedicationRequest/Example-MR-Dosage-interval-2d-bound](MedicationRequest-Example-MR-Dosage-interval-2d-bound.md),[MedicationRequest/Example-MR-Dosage-interval-2wk](MedicationRequest-Example-MR-Dosage-interval-2wk.md),[MedicationRequest/Example-MR-Dosage-interval-3d](MedicationRequest-Example-MR-Dosage-interval-3d.md),[MedicationRequest/Example-MR-Dosage-interval-4times-d](MedicationRequest-Example-MR-Dosage-interval-4times-d.md),[MedicationRequest/Example-MR-Dosage-interval-8d](MedicationRequest-Example-MR-Dosage-interval-8d.md),[MedicationRequest/Example-MR-Dosage-tod-1t-8am](MedicationRequest-Example-MR-Dosage-tod-1t-8am.md),[MedicationRequest/Example-MR-Dosage-tod-2-12am](MedicationRequest-Example-MR-Dosage-tod-2-12am.md),[MedicationRequest/Example-MR-Dosage-tod-multi-bound](MedicationRequest-Example-MR-Dosage-tod-multi-bound.md),[MedicationRequest/Example-MR-Dosage-tod-multi](MedicationRequest-Example-MR-Dosage-tod-multi.md),[MedicationRequest/Example-MR-Dosage-tod-unsorted](MedicationRequest-Example-MR-Dosage-tod-unsorted.md),[MedicationRequest/Example-MR-Dosage-weekday-2t-1t](MedicationRequest-Example-MR-Dosage-weekday-2t-1t.md),[MedicationRequest/Example-MR-Dosage-weekday-2t-bound](MedicationRequest-Example-MR-Dosage-weekday-2t-bound.md),[MedicationRequest/Example-MR-Dosage-weekday-2t](MedicationRequest-Example-MR-Dosage-weekday-2t.md),[MedicationRequest/Example-MR-Dosage-weekday-3t](MedicationRequest-Example-MR-Dosage-weekday-3t.md),[MedicationRequest/Example-MR-Dosage-weekday-unsorted](MedicationRequest-Example-MR-Dosage-weekday-unsorted.md),[MedicationRequest/Example-MR-DosageTr-1000](MedicationRequest-Example-MR-DosageTr-1000.md),[MedicationRequest/Invalid-C-TimingOnlyOneType-01-of-08](MedicationRequest-Invalid-C-TimingOnlyOneType-01-of-08.md),[MedicationRequest/Invalid-C-TimingOnlyOneType-02-of-08](MedicationRequest-Invalid-C-TimingOnlyOneType-02-of-08.md),[MedicationRequest/Invalid-C-TimingOnlyOneType-03-of-08](MedicationRequest-Invalid-C-TimingOnlyOneType-03-of-08.md),[MedicationRequest/Invalid-C-TimingOnlyOneType-04-of-08](MedicationRequest-Invalid-C-TimingOnlyOneType-04-of-08.md),[MedicationRequest/Invalid-C-TimingOnlyOneType-05-of-08](MedicationRequest-Invalid-C-TimingOnlyOneType-05-of-08.md),[MedicationRequest/Invalid-C-TimingOnlyWhenOrTimeOfDay-01-of-01](MedicationRequest-Invalid-C-TimingOnlyWhenOrTimeOfDay-01-of-01.md),[MedicationRequest/Invalid-Dosage-01-of-12-FreqPeriod-When](MedicationRequest-Invalid-Dosage-01-of-12-FreqPeriod-When.md)and[MedicationRequest/Invalid-Dosage-02-of-12-FreqPeriod-ToD-DayOfWeek](MedicationRequest-Invalid-Dosage-02-of-12-FreqPeriod-ToD-DayOfWeek.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.fhir.medication|current/StructureDefinition/MedicationRequestDgMP)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-MedicationRequestDgMP.csv), [Excel](StructureDefinition-MedicationRequestDgMP.xlsx), [Schematron](StructureDefinition-MedicationRequestDgMP.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "MedicationRequestDgMP",
  "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP",
  "version" : "1.0.1",
  "name" : "MedicationRequestDgMP",
  "title" : "Medication Request dgMP",
  "status" : "active",
  "date" : "2025-10-20T12:04:13+02:00",
  "publisher" : "HL7 Deutschland e.V.",
  "contact" : [
    {
      "name" : "HL7 Deutschland e.V.",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.de"
        }
      ]
    }
  ],
  "description" : "Dieses Profil dient ausschließlich der Validierung des Implementation Guides und ist nicht für den produktiven Einsatz gedacht. Stattdessen sollte das jeweils passende Dosage-Profil direkt in das eigene Profil eingebunden werden.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "script10.6",
      "uri" : "http://ncpdp.org/SCRIPT10_6",
      "name" : "Mapping to NCPDP SCRIPT 10.6"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : true,
  "type" : "MedicationRequest",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MedicationRequest",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationRequest",
        "path" : "MedicationRequest"
      },
      {
        "id" : "MedicationRequest.extension:renderedDosageInstruction",
        "path" : "MedicationRequest.extension",
        "sliceName" : "renderedDosageInstruction",
        "short" : "Dosierungsanweisung",
        "definition" : "Diese R5 backport Extension enthält die algorithmisch generierten gerenderten Dosierungsanweisungen, die für den Patienten bestimmt sind, um eine klare und verständliche Anweisung zur Einnahme des Medikaments zu geben.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.renderedDosageInstruction"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.extension:renderedDosageInstruction.value[x]",
        "path" : "MedicationRequest.extension.value[x]",
        "short" : "Hinweis: In der ersten Ausbaustufe des dgMP ist nur einfacher Text (String) zulässig; Markdown wird nicht unterstützt.",
        "definition" : "Abweichend von FHIR R5 (Typ Markdown) darf in der ersten Ausbaustufe des dgMP ausschließlich Klartext ohne Markdown‑Formatierungen (z. B. Überschriften, Listen, Links) geliefert werden."
      },
      {
        "id" : "MedicationRequest.extension:generatedDosageInstructionsMeta",
        "path" : "MedicationRequest.extension",
        "sliceName" : "generatedDosageInstructionsMeta",
        "short" : "Metadaten zu den generierten Dosierungsanweisungen",
        "definition" : "Diese Extension enthält zusätzliche Metadaten zu den automatisch generierten Dosierungsanweisungen, wie z.B. Informationen zur Generierung oder zum Ursprung der Daten.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dosageInstruction",
        "path" : "MedicationRequest.dosageInstruction",
        "short" : "Angabe der Dosierinformationen strukturiert oder als Freitext",
        "type" : [
          {
            "code" : "Dosage",
            "profile" : [
              "http://ig.fhir.de/igs/medication/StructureDefinition/DosageDgMP"
            ]
          }
        ]
      }
    ]
  }
}

```
