# Generated Dosage Instructions Meta - Medication IG DE v1.0.1

* [**Table of Contents**](toc.md)
* [**FHIR Summary**](artifacts.md)
* **Generated Dosage Instructions Meta**

## Extension: Generated Dosage Instructions Meta 

| | |
| :--- | :--- |
| *Official URL*:http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta | *Version*:1.0.1 |
| Active as of 2025-10-20 | *Computable Name*:GeneratedDosageInstructionsMetaEx |

Diese Extension enthält die Metainformationen zur generierten textuellen Dosierungsanweisung, die auf Basis der bereitgestellten strukturierten Dosierungsinformationen erstellt wurde.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Medication Dispense dgMP](StructureDefinition-MedicationDispenseDgMP.md), [Medication Request dgMP](StructureDefinition-MedicationRequestDgMP.md) and [Medication Statement dgMP](StructureDefinition-MedicationStatementDgMP.md)
* Examples for this Extension: [MedicationDispense/MD-Dosage-1020](MedicationDispense-MD-Dosage-1020.md), [MedicationDispense/MD-Dosage-Bounds-Decimals](MedicationDispense-MD-Dosage-Bounds-Decimals.md), [MedicationDispense/MD-Dosage-DayOfWeek-Time](MedicationDispense-MD-Dosage-DayOfWeek-Time.md), [MedicationDispense/MD-Dosage-Freetext](MedicationDispense-MD-Dosage-Freetext.md)...Show 46 more,[MedicationDispense/MD-Dosage-Interval-Time](MedicationDispense-MD-Dosage-Interval-Time.md),[MedicationRequest/Example-MR-Bug-EmptyLists](MedicationRequest-Example-MR-Bug-EmptyLists.md),[MedicationRequest/Example-MR-Bug-MultipleTimeOfDay-Daily](MedicationRequest-Example-MR-Bug-MultipleTimeOfDay-Daily.md),[MedicationRequest/Example-MR-Bug-MultipleTimeOfDay-DayOfWeek](MedicationRequest-Example-MR-Bug-MultipleTimeOfDay-DayOfWeek.md),[MedicationRequest/Example-MR-Bug-MultipleTimeOfDay-Interval](MedicationRequest-Example-MR-Bug-MultipleTimeOfDay-Interval.md),[MedicationRequest/Example-MR-Bug-MultipleWhen-DayOfWeek](MedicationRequest-Example-MR-Bug-MultipleWhen-DayOfWeek.md),[MedicationRequest/Example-MR-Bug-MultipleWhen-Interval](MedicationRequest-Example-MR-Bug-MultipleWhen-Interval.md),[MedicationRequest/Example-MR-Dosage-1000](MedicationRequest-Example-MR-Dosage-1000.md),[MedicationRequest/Example-MR-Dosage-1010-10-Days](MedicationRequest-Example-MR-Dosage-1010-10-Days.md),[MedicationRequest/Example-MR-Dosage-1010-Unsorted](MedicationRequest-Example-MR-Dosage-1010-Unsorted.md),[MedicationRequest/Example-MR-Dosage-1010](MedicationRequest-Example-MR-Dosage-1010.md),[MedicationRequest/Example-MR-Dosage-10120](MedicationRequest-Example-MR-Dosage-10120.md),[MedicationRequest/Example-MR-Dosage-1020-Unordered](MedicationRequest-Example-MR-Dosage-1020-Unordered.md),[MedicationRequest/Example-MR-Dosage-1020](MedicationRequest-Example-MR-Dosage-1020.md),[MedicationRequest/Example-MR-Dosage-1111](MedicationRequest-Example-MR-Dosage-1111.md),[MedicationRequest/Example-MR-Dosage-1220](MedicationRequest-Example-MR-Dosage-1220.md),[MedicationRequest/Example-MR-Dosage-Freetext](MedicationRequest-Example-MR-Dosage-Freetext.md),[MedicationRequest/Example-MR-Dosage-UnitStueck-1020](MedicationRequest-Example-MR-Dosage-UnitStueck-1020.md),[MedicationRequest/Example-MR-Dosage-UnitTasse-1000](MedicationRequest-Example-MR-Dosage-UnitTasse-1000.md),[MedicationRequest/Example-MR-Dosage-comb-dayofweek-1](MedicationRequest-Example-MR-Dosage-comb-dayofweek-1.md),[MedicationRequest/Example-MR-Dosage-comb-dayofweek-2](MedicationRequest-Example-MR-Dosage-comb-dayofweek-2.md),[MedicationRequest/Example-MR-Dosage-comb-dayofweek-3](MedicationRequest-Example-MR-Dosage-comb-dayofweek-3.md),[MedicationRequest/Example-MR-Dosage-comb-dayofweek-unsorted](MedicationRequest-Example-MR-Dosage-comb-dayofweek-unsorted.md),[MedicationRequest/Example-MR-Dosage-comb-interval-1](MedicationRequest-Example-MR-Dosage-comb-interval-1.md),[MedicationRequest/Example-MR-Dosage-comb-interval-2](MedicationRequest-Example-MR-Dosage-comb-interval-2.md),[MedicationRequest/Example-MR-Dosage-comb-interval-3](MedicationRequest-Example-MR-Dosage-comb-interval-3.md),[MedicationRequest/Example-MR-Dosage-comb-interval-4](MedicationRequest-Example-MR-Dosage-comb-interval-4.md),[MedicationRequest/Example-MR-Dosage-interval-2d-bound](MedicationRequest-Example-MR-Dosage-interval-2d-bound.md),[MedicationRequest/Example-MR-Dosage-interval-2wk](MedicationRequest-Example-MR-Dosage-interval-2wk.md),[MedicationRequest/Example-MR-Dosage-interval-3d](MedicationRequest-Example-MR-Dosage-interval-3d.md),[MedicationRequest/Example-MR-Dosage-interval-4times-d](MedicationRequest-Example-MR-Dosage-interval-4times-d.md),[MedicationRequest/Example-MR-Dosage-interval-8d](MedicationRequest-Example-MR-Dosage-interval-8d.md),[MedicationRequest/Example-MR-Dosage-tod-1t-8am](MedicationRequest-Example-MR-Dosage-tod-1t-8am.md),[MedicationRequest/Example-MR-Dosage-tod-2-12am](MedicationRequest-Example-MR-Dosage-tod-2-12am.md),[MedicationRequest/Example-MR-Dosage-tod-multi-bound](MedicationRequest-Example-MR-Dosage-tod-multi-bound.md),[MedicationRequest/Example-MR-Dosage-tod-multi](MedicationRequest-Example-MR-Dosage-tod-multi.md),[MedicationRequest/Example-MR-Dosage-tod-unsorted](MedicationRequest-Example-MR-Dosage-tod-unsorted.md),[MedicationRequest/Example-MR-Dosage-weekday-2t-1t](MedicationRequest-Example-MR-Dosage-weekday-2t-1t.md),[MedicationRequest/Example-MR-Dosage-weekday-2t-bound](MedicationRequest-Example-MR-Dosage-weekday-2t-bound.md),[MedicationRequest/Example-MR-Dosage-weekday-2t](MedicationRequest-Example-MR-Dosage-weekday-2t.md),[MedicationRequest/Example-MR-Dosage-weekday-3t](MedicationRequest-Example-MR-Dosage-weekday-3t.md),[MedicationRequest/Example-MR-Dosage-weekday-unsorted](MedicationRequest-Example-MR-Dosage-weekday-unsorted.md),[MedicationRequest/Example-MR-DosageTr-1000](MedicationRequest-Example-MR-DosageTr-1000.md),[MedicationRequest/Invalid-C-TimingOnlyOneType-01-of-08](MedicationRequest-Invalid-C-TimingOnlyOneType-01-of-08.md),[MedicationRequest/Invalid-C-TimingOnlyOneType-02-of-08](MedicationRequest-Invalid-C-TimingOnlyOneType-02-of-08.md)and[MedicationRequest/Invalid-C-TimingOnlyOneType-03-of-08](MedicationRequest-Invalid-C-TimingOnlyOneType-03-of-08.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.fhir.medication|current/StructureDefinition/GeneratedDosageInstructionsMeta)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-GeneratedDosageInstructionsMeta.csv), [Excel](StructureDefinition-GeneratedDosageInstructionsMeta.xlsx), [Schematron](StructureDefinition-GeneratedDosageInstructionsMeta.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "GeneratedDosageInstructionsMeta",
  "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta",
  "version" : "1.0.1",
  "name" : "GeneratedDosageInstructionsMetaEx",
  "title" : "Generated Dosage Instructions Meta",
  "status" : "active",
  "date" : "2025-10-20T12:04:13+02:00",
  "publisher" : "HL7 Deutschland e.V.",
  "contact" : [
    {
      "name" : "HL7 Deutschland e.V.",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.de"
        }
      ]
    }
  ],
  "description" : "Diese Extension enthält die Metainformationen zur generierten textuellen Dosierungsanweisung, die auf Basis der bereitgestellten strukturierten Dosierungsinformationen erstellt wurde.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "MedicationRequest"
    },
    {
      "type" : "element",
      "expression" : "MedicationDispense"
    },
    {
      "type" : "element",
      "expression" : "MedicationStatement"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Generated Dosage Instructions Meta",
        "definition" : "Diese Extension enthält die Metainformationen zur generierten textuellen Dosierungsanweisung, die auf Basis der bereitgestellten strukturierten Dosierungsinformationen erstellt wurde."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "min" : 2
      },
      {
        "id" : "Extension.extension:language",
        "path" : "Extension.extension",
        "sliceName" : "language",
        "short" : "Sprache der generierten Dosierungsanweisung",
        "comment" : "Zur Auswahl der deutschen Sprache sollte der Code 'de-DE' verwendet werden",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:language.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:language.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "language"
      },
      {
        "id" : "Extension.extension:language.value[x]",
        "path" : "Extension.extension.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Extension.extension:language.value[x]:valueCode",
        "path" : "Extension.extension.value[x]",
        "sliceName" : "valueCode",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/all-languages"
        }
      },
      {
        "id" : "Extension.extension:algorithmVersion",
        "path" : "Extension.extension",
        "sliceName" : "algorithmVersion",
        "short" : "Version des Algorithmus zur Generierung der Dosierungsanweisung (Version der zugrundeliegenden Python Referenzimplementierung)",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:algorithmVersion.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:algorithmVersion.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "algorithmVersion"
      },
      {
        "id" : "Extension.extension:algorithmVersion.value[x]",
        "path" : "Extension.extension.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Extension.extension:algorithmVersion.value[x]:valueString",
        "path" : "Extension.extension.value[x]",
        "sliceName" : "valueString",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
