# Example-MR-Dosage-comb-dayofweek-3 - Medication IG DE v1.0.1

* [**Table of Contents**](toc.md)
* [**FHIR Summary**](artifacts.md)
* **Example-MR-Dosage-comb-dayofweek-3**

## Example MedicationRequest: Example-MR-Dosage-comb-dayofweek-3

Profile: [Medication Request dgMP](StructureDefinition-MedicationRequestDgMP.md)

**Extension Definition for MedicationRequest.renderedDosageInstruction for Version 5.0**: 

für 3 Wochen: montags 1-2-0-0 Stück; freitags 1-2-0-0 Stück

> **Generated Dosage Instructions Meta**
* algorithmVersion: 1.0.1
* language: de-DE

**status**: Active

**intent**: Order

**medication**: Ibuprofen 400mg

**subject**: Patient

> **dosageInstruction****timing**: Morning, 2 per 1 week

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 1 Stück(Details: KBV_CS_SFHIR_BMP_DOSIEREINHEIT code1 = '1') |


> **dosageInstruction****timing**: Noon, 2 per 1 week

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 2 Stück(Details: KBV_CS_SFHIR_BMP_DOSIEREINHEIT code1 = '1') |




## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "Example-MR-Dosage-comb-dayofweek-3",
  "meta" : {
    "profile" : [
      "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.renderedDosageInstruction",
      "valueMarkdown" : "für 3 Wochen: montags 1-2-0-0 Stück; freitags 1-2-0-0 Stück"
    },
    {
      "extension" : [
        {
          "url" : "algorithmVersion",
          "valueString" : "1.0.1"
        },
        {
          "url" : "language",
          "valueCode" : "de-DE"
        }
      ],
      "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
    }
  ],
  "status" : "active",
  "intent" : "order",
  "medicationCodeableConcept" : {
    "text" : "Ibuprofen 400mg"
  },
  "subject" : {
    "display" : "Patient"
  },
  "dosageInstruction" : [
    {
      "timing" : {
        "repeat" : {
          "boundsDuration" : {
            "value" : 3,
            "unit" : "Woche(n)",
            "system" : "http://unitsofmeasure.org",
            "code" : "wk"
          },
          "frequency" : 2,
          "period" : 1,
          "periodUnit" : "wk",
          "dayOfWeek" : ["mon", "fri"],
          "when" : ["MORN"]
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 1,
            "unit" : "Stück",
            "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
            "code" : "1"
          }
        }
      ]
    },
    {
      "timing" : {
        "repeat" : {
          "boundsDuration" : {
            "value" : 3,
            "unit" : "Woche(n)",
            "system" : "http://unitsofmeasure.org",
            "code" : "wk"
          },
          "frequency" : 2,
          "period" : 1,
          "periodUnit" : "wk",
          "dayOfWeek" : ["mon", "fri"],
          "when" : ["NOON"]
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 2,
            "unit" : "Stück",
            "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
            "code" : "1"
          }
        }
      ]
    }
  ]
}

```
